<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe_child
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_child_settingstopbar', get_string('settingstopbar', 'theme_universe_child'));

$name = 'theme_universe_child/topbarscss';
$title = get_string('topbarscss', 'theme_universe_child');
$description = get_string('topbarscss_desc', 'theme_universe_child');
$setting = new universe_setting_infosettingheading($name, $title, $description);
$page->add($setting);

// Prepare hide nodes options.
$hidenodesoptions = array(
    'home' => get_string('home'),
    'myhome' => get_string('myhome'),
    'courses' => get_string('mycourses')
);

// General settings.
$name = 'theme_universe_child/hlogoareageneral';
$heading = get_string('hlogoareageneral', 'theme_universe_child');
$title = get_string('hlogoareageneral_desc', 'theme_universe_child');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

// Setting: Hide nodes in primary navigation.
$name = 'theme_universe_child/hidenodesprimarynavigation';
$title = get_string('hidenodesprimarynavigationsetting', 'theme_universe_child', null, true);
$description = get_string('hidenodesprimarynavigationsetting_desc', 'theme_universe_child', null, true);
$setting = new admin_setting_configmulticheckbox($name, $title, $description, array(), $hidenodesoptions);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/topbareditmode';
$title = get_string('topbareditmode', 'theme_universe_child');
$description = get_string('topbareditmode_desc', 'theme_universe_child', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/topbarcustomhtml';
$title = get_string('topbarcustomhtml', 'theme_universe_child');
$description = get_string('topbarcustomhtml_desc', 'theme_universe_child', $a);
$default = '';
$setting = new admin_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

// Custom Logo.
$name = 'theme_universe_child/hlogoarea';
$heading = get_string('hlogoarea', 'theme_universe_child');
$title = get_string('hlogoarea_desc', 'theme_universe_child');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe_child/topbarlogoareaon';
$title = get_string('topbarlogoareaon', 'theme_universe_child');
$description = get_string('topbarlogoareaon_desc', 'theme_universe_child');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/customlogo';
$title = get_string('customlogo', 'theme_universe_child');
$description = get_string('customlogo_desc', 'theme_universe_child');
$opts = array('accepted_types' => array('.png', '.jpg', '.svg', 'gif'));
$setting = new admin_setting_configstoredfile($name, $title, $description, 'customlogo', 0, $opts);
$page->add($setting);

$name = 'theme_universe_child/customdmlogo';
$title = get_string('customdmlogo', 'theme_universe_child');
$description = get_string('customdmlogo_desc', 'theme_universe_child');
$opts = array('accepted_types' => array('.png', '.jpg', '.svg', 'gif'));
$setting = new admin_setting_configstoredfile($name, $title, $description, 'customdmlogo', 0, $opts);
$page->add($setting);

$name = 'theme_universe_child/navbarlogobox';
$title = get_string('navbarlogobox', 'theme_universe_child');
$description = get_string('navbarlogobox_desc', 'theme_universe_child', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/customlogoandname';
$title = get_string('customlogoandname', 'theme_universe_child');
$description = get_string('customlogoandname_desc', 'theme_universe_child');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/customlogotxt';
$title = get_string('customlogotxt', 'theme_universe_child');
$description = get_string('customlogotxt_desc', 'theme_universe_child');
$default = 'universe';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Colors.
$name = 'theme_universe_child/htopbarcolors';
$heading = get_string('htopbarcolors', 'theme_universe_child');
$title = get_string('htopbarcolors_desc', 'theme_universe_child');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe_child/colortopbarbg1';
$title = get_string('colortopbarbg1', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/dmcolortopbarbg1';
$title = get_string('dmcolortopbarbg1', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/colortopbarbg2';
$title = get_string('colortopbarbg2', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/dmcolortopbarbg2';
$title = get_string('dmcolortopbarbg2', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/colortopbartext';
$title = get_string('colortopbartext', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/colortopbarbtntext';
$title = get_string('colortopbarbtntext', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/colortopbarbtnhover';
$title = get_string('colortopbarbtnhover', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/colortopbarbtnhovertext';
$title = get_string('colortopbarbtnhovertext', 'theme_universe_child');
$description = get_string('color_desc', 'theme_universe_child');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Additional Button next to the Log in button.
$name = 'theme_universe_child/hadditionalbtn';
$heading = get_string('hadditionalbtn', 'theme_universe_child');
$title = get_string('hadditionalbtn_desc', 'theme_universe_child');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe_child/topbaradditionalbtn';
$title = get_string('topbaradditionalbtn', 'theme_universe_child');
$description = get_string('topbaradditionalbtn_desc', 'theme_universe_child');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe_child/stopbaradditionalbtn';
$title = get_string('stopbaradditionalbtn', 'theme_universe_child');
$description = get_string('stopbaradditionalbtn_desc', 'theme_universe_child');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe_child/topbaradditionalbtnurl';
$title = get_string('topbaradditionalbtnurl', 'theme_universe_child');
$description = get_string('topbaradditionalbtnurl_desc', 'theme_universe_child');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
