<?php
defined('MOODLE_INTERNAL') || die();

function theme_universe_child_inherit_settings()
{
    global $CFG;

    // Get parent theme settings
    $parent_settings = [];
    $parent_settings_dir = $CFG->dirroot . '/theme/universe/settings/';

    if (is_dir($parent_settings_dir)) {
        $files = scandir($parent_settings_dir);
        foreach ($files as $file) {
            if (pathinfo($file, PATHINFO_EXTENSION) === 'php') {
                $parent_settings[] = $file;
            }
        }
    }

    return $parent_settings;
}

function theme_universe_child_apply_settings($settings)
{
    global $CFG;

    // Apply parent theme settings to child theme
    foreach ($settings as $setting) {
        $parent_setting = $CFG->dirroot . '/theme/universe/settings/' . $setting;
        if (file_exists($parent_setting)) {
            require_once($parent_setting);
        }
    }
}
