<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

// Advanced settings.
$page = new admin_settingpage(
    'theme_universe_advanced',
    get_string('advancedsettings', 'theme_universe')
);

// H5P custom CSS.
$setting = new admin_setting_configtextarea(
    'theme_universe/hvpcss',
    get_string('hvpcss', 'theme_universe'),
    get_string('hvpcss_desc', 'theme_universe'), '');
$page->add($setting);

// Raw SCSS to include before the content.
$setting = new admin_setting_scsscode(
    'theme_universe/scsspre',
    get_string('rawscsspre', 'theme_universe'),
    get_string('rawscsspre_desc', 'theme_universe'),
    '',
    PARAM_RAW
);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Raw SCSS to include after the content.
$setting = new admin_setting_scsscode(
    'theme_universe/scss',
    get_string('rawscss', 'theme_universe'),
    get_string('rawscss_desc', 'theme_universe'),
    '',
    PARAM_RAW
);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Font files upload.
// Setting: Custom fonts.
$name = 'theme_universe/fontfiles';
$title = get_string('customfontssetting', 'theme_universe', null, true);
$description = get_string('customfontssetting_desc', 'theme_universe', null, true);
if ($registerfontsresult == true) {
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'fontfiles', 0,
            ['maxfiles' => -1, 'accepted_types' => theme_universe_get_webfonts_extensions()]);
} else {
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'fontfiles', 0,
            ['maxfiles' => -1]);
}
$page->add($setting);

// Information: Custom fonts list.
// Credits: Boost_Union
// If there is at least one file uploaded.
if (!empty(get_config('theme_universe', 'fontfiles'))) {
    // Prepare the widget.
    $name = 'theme_universe/customfontslist';
    $title = get_string('customfontslistsetting', 'theme_universe', null, true);
    $description = get_string('customfontslistsetting_desc', 'theme_universe', null, true);

    // Append the file list to the description.
    $templatecontext = ['files' => theme_universe_get_customfonts_templatecontext()];
    $description .= $OUTPUT->render_from_template('theme_universe/settings-customfonts-filelist', $templatecontext);

    // Finish the widget.
    $setting = new admin_setting_description($name, $title, $description);
    $page->add($setting);
}

// Additional files
$name = 'theme_universe/additionalresources';
$title = get_string('additionalresourcessetting', 'theme_universe', null, true);
$description = get_string('additionalresourcessetting_desc', 'theme_universe', null, true);
$setting = new admin_setting_configstoredfile($name, $title, $description, 'additionalresources', 0,
        ['maxfiles' => -1]);
$page->add($setting);

// Information: Additional resources list.
// If there is at least one file uploaded.
if (!empty(get_config('theme_universe', 'additionalresources'))) {
    // Prepare the widget.
    $name = 'theme_universe/additionalresourceslist';
    $title = get_string('additionalresourceslistsetting', 'theme_universe', null, true);
    $description = get_string('additionalresourceslistsetting_desc', 'theme_universe', null, true).'<br /><br />'.
            get_string('resourcescachecontrolnote', 'theme_universe', null, true);

    // Append the file list to the description.
    $templatecontext = ['files' => theme_universe_get_additionalresources_templatecontext()];
    $description .= $OUTPUT->render_from_template('theme_universe/settings-additionalresources-filelist',
            $templatecontext);

    // Finish the widget.
    $setting = new admin_setting_description($name, $title, $description);
    $page->add($setting);
}

$settings->add($page);
