//
// This file is part of universe theme for moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
//
//
// universe main JS file
//
// @package    theme_universe
// @copyright  Copyright © 2021 onwards Marcin Czaja Rosea Themes
//
// @license    Commercial

/* jshint ignore:start */
define(["jquery", "core_user/repository"], function ($, UserRepository) {
  "use strict";

  return {
    init: function () {
      $(document).ready(function () {
        var trigger = $("#darkModeBtn");
        if (trigger.length) {
          var preference = trigger.attr("data-preference");

          trigger.click(function () {
            $("body").toggleClass("theme-dark");
            $("html").toggleClass("dark-mode");
            var isDarkMode = $("body").hasClass("theme-dark");
            trigger.attr("aria-checked", isDarkMode.toString());
            UserRepository.setUserPreference(preference, isDarkMode);
          });
        }

        function toggleDrawer() {
          $("body").toggleClass(
            "drawer-courseindex--open drawer-open-index--open"
          );
        }

        $(".btn-drawer--left, .drawertoggle").click(toggleDrawer);

        $("#courseindexbtn, .bulkEnable").click(function () {
          $("#course-tab2").tab("show");
        });

        if ($("body").hasClass("drawer-courseindex--open")) {
          $("#course-tab2").tab("show");
        }

        $("#mobileNav, .rui-mobile-nav-btn-close").click(function () {
          $("#topBar").toggleClass("opened");
        });

        $("#showBlockArea").click(function () {
          $("body").toggleClass("rui-edit-areas");
          $(this).toggleClass("active");
        });

        $(".rui-nav--admin .nav-link").each(function () {
          var text = $(this).html();
          $(this).html(
            text
              .replace("(", '<span class="mt-1 small d-block">')
              .replace(")", "</span>")
          );
        });
      });
    },
  };
});

/* jshint ignore:end */
