<?php
use core_completion\progress;

class block_progreso_sinopsis_renderer extends plugin_renderer_base {

    public function procesar($instance_id) {

        global $USER, $CFG;
        
       // require_once $CFG->libdir . '/grade/grade_item.php';
       
        require_once $CFG->libdir . '/completionlib.php';
        require_once $CFG->dirroot.'/completion/classes/progress.php';
        
        require_once $CFG->libdir . '/gradelib.php';
        require_once $CFG->dirroot . '/grade/querylib.php';



        $mycourses = enrol_get_users_courses($USER->id);
        $max_time   = time();
        $min_time   = strtotime('-1 YEAR');
        $limit      = 3600;
        
        $dedication = 0;
        $completed  = 0;
        $inprogress = 0;
        $grades     = 0;
        $points     = 0;
        
        
        foreach($mycourses as $key => $val) {
            $course = get_course($val->id);
            $completion = new \completion_info($course);
            //$completion = new completion_info($course);
            if ($completion->is_enabled()) {
                $percentage = progress::get_course_progress_percentage($course);
                $percentage = !$percentage ? 0 : $percentage;
                
                $points += $percentage;
                
                if($percentage >= 100) {
                    $completed++;
                } else {
                    $inprogress++;
                }
            } else {
                $inprogress++;
            }
            
            $resultkrb =  grade_get_course_grades($course->id, $USER->id);

            
            $grd = $resultkrb->grades[$USER->id];
            if('-' != $grd->str_grade) {
                $grades++;
            }
            $dedication = $dedication + $this->get_students_dedication($USER->id, $course->id, $min_time, $max_time, $limit);
            //var_dump($dedication);//test
            //die();
        }
        
        if(0 != $completed || 0 != $inprogress) {
            $points = (int) ($points / ($completed + $inprogress));
        }
        

        
        $data = [
            'dedication'    => $this->format_dedication($dedication),
            'completed'     => $completed,
            'inprogress'    => $inprogress,
            'grades'        => $grades,
            'points'    => $points,
        ];
        //var_dump($data);//test
        //die();
        return $this->render_from_template('block_progreso_sinopsis/full', $data);
    }
    
    public static function format_dedication($totalsecs) {
        $totalsecs = abs($totalsecs);
        
        $str = new stdClass();
        $str->hour = get_string('hour');
        $str->hours = get_string('hours');
        $str->min = get_string('min');
        $str->mins = get_string('mins');
        $str->sec = get_string('sec');
        $str->secs = get_string('secs');
        
        $hours = floor($totalsecs / HOURSECS);
        $remainder = $totalsecs - ($hours * HOURSECS);
        $mins = floor($remainder / MINSECS);
        $secs = round($remainder - ($mins * MINSECS), 2);
        
        $ss = ($secs == 1) ? $str->sec : $str->secs;
        $sm = ($mins == 1) ? $str->min : $str->mins;
        $sh = ($hours == 1) ? $str->hour : $str->hours;
        
        $ohours = '';
        $omins = '';
        $osecs = '';
        
        
        if ($hours) {
           // $ohours = $hours . ' ' . $sh;
            $ohours = $hours . ' ' . 'h';
        }
        if ($mins) {
            //$omins = $mins . ' ' . $sm;
            $omins = $mins . ' ' . 'm';
        }
        if ($secs) {
            //$osecs = $secs . ' ' . $ss;
	    $osecs = $secs . ' ' . 's';
        }
        
        if ($hours) {
            return trim($ohours . ' ' . $omins);
        }
        if ($mins) {
            return trim($omins . ' ' . $osecs);
        }
        if ($secs) {
            return $osecs;
        }       

        return get_string('none');
        
        
    }

    public function get_events_select($selectwhere, array $params) 
    {
        $logstores  = ['logstore_standard', 'logstore_legacy'];
        $return     = [];
        
        static $allreaders = null;
        
        if (is_null($allreaders)) {
            $allreaders = get_log_manager()->get_readers();
        }
        
        $processedreaders = 0;
        
        foreach ($logstores as $name) {
            if (isset($allreaders[$name])) {
                $reader = $allreaders[$name];
                $events = $reader->get_events_select($selectwhere, $params, 'timecreated ASC', 0, 0);
                foreach ($events as $event) {
                    // Note: see \core\event\base to view base class of event.
                    $obj = new stdClass();
                    $obj->time = $event->timecreated;
                    $obj->ip = $event->get_logextra()['ip'];
                    $return[] = $obj;
                }
                if (!empty($events)) {
                    $processedreaders++;
                }
            }
        }
        
        // Sort mixed array by time ascending again only when more of a reader has added events to return array.
        if ($processedreaders > 1) {
            usort($return, function($a, $b) {
                return $a->time > $b->time;
            });
        }
        
        return $return;
    }
    
    public function get_students_dedication($user_id, $course_id, $min_time, $max_time, $limit) 
    {

        $where = 'courseid = :courseid AND userid = :userid AND timecreated >= :mintime AND timecreated <= :maxtime';
        $params = array(
            'courseid'  => $course_id,
            'userid'    => $user_id,
            'mintime'   => $min_time,
            'maxtime'   => $max_time
        );

        //var_dump($params);//test
        //die();
        
        
        $logs = $this->get_events_select($where, $params);
        if ($logs) {
            $previouslog = array_shift($logs);
            $previouslogtime = $previouslog->time;
            $sessionstart = $previouslog->time;
            $dedication = 0;
                
            foreach ($logs as $log) {
                if (($log->time - $previouslogtime) > $limit) {
                    $dedication += $previouslogtime - $sessionstart;
                    $sessionstart = $log->time;
                }
                $previouslogtime = $log->time;
            }
            $dedication += $previouslogtime - $sessionstart;
        } else {
            $dedication = 0;
        }


       // var_dump($dedication);//test
        //die();

        return $dedication;
        
    }
    
   
    
    
    

}
