<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
//POST, GET, DELETE, PUT, PATCH, OPTIONS
header('Access-Control-Allow-Headers: token, Content-Type');
header('Access-Control-Max-Age: 1728000');


header('Content-Type: application/json');



require_once(__DIR__ . '/config.php');
require_once(__DIR__ . '/../config.php');
global $DB, $PAGE, $CFG;

require_once($CFG->libdir.'/moodlelib.php');
require_once($CFG->libdir . '/externallib.php');
require_once($CFG->libdir.'/authlib.php');
require_once( $CFG->libdir . '/gdlib.php' );

require_once($CFG->dirroot.'/user/lib.php');
require_once __DIR__ . '/rsa.php';
require_once __DIR__ . '/lib.php';

header('Content-type: text/plain');


$username   = trim(isset($_SERVER['HTTP_USERNAME']) ? filter_var($_SERVER['HTTP_USERNAME'], FILTER_SANITIZE_STRING) : '');
$password   = trim(isset($_SERVER['HTTP_PASSWORD']) ? filter_var($_SERVER['HTTP_PASSWORD'], FILTER_SANITIZE_STRING) : '');
$timestamp  = trim(isset($_SERVER['HTTP_TIMESTAMP']) ? filter_var($_SERVER['HTTP_TIMESTAMP'], FILTER_SANITIZE_STRING) : '');
$rand       = intval(isset($_SERVER['HTTP_RAND']) ? filter_var($_SERVER['HTTP_RAND'], FILTER_SANITIZE_NUMBER_INT) : 0,10);
$id         = intval(isset($_GET['id']) ? filter_var($_GET['id'], FILTER_SANITIZE_NUMBER_INT) : 0,10);


if(empty($username) || empty($password) || empty($timestamp) || empty($rand) || !is_integer($rand)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY1']) ;
    exit;
}

if($username != LLWS_USERNAME) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY2']) ;
    exit;
}

$dt = \DateTime::createFromFormat('Y-m-d\TH:i:s', $timestamp);
if(!$dt) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY3']) ;
    exit;
}

$dt = \DateTimeImmutable::createFromFormat('Y-m-d\TH:i:s',  gmdate('Y-m-d\TH:i:s'));
$dtMax = $dt->add(\DateInterval::createFromDateString('5 minutes'));
$dtMin = $dt->sub(\DateInterval::createFromDateString('5 minutes'));


$t0 = $dt->getTimestamp();
$t1 = $dtMin->getTimestamp();
$t2 = $dtMax->getTimestamp();

if($t0 < $t1 || $t0 > $t2) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY4']) ;
    exit;
}

if(!password_verify( $username.'-'. LLWS_PASSWORD. '-' . $rand. '-' . $timestamp, $password)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY5']) ;
    exit;
}



$course = get_course($id);
if(!$course) {
    echo json_encode([
        'success' => false,
        'data' => 'El curso solicitado no existe'
    ]); 
    exit;
}

$enrolmethod = 'manual';


$enrol = enrol_get_plugin($enrolmethod);
if (!$enrol) {
    echo json_encode([
        'success' => false,
        'data' => 'El Plugin de enrolamiento manual no esta disponible'
    ]); 
    exit;
}

$instances = enrol_get_instances($course->id, true);
$manualinstance = null;
foreach ($instances as $instance) 
{
    if ($instance->enrol == $enrolmethod) {
        $manualinstance = $instance;
        break;
    }
}


        
if (!$manualinstance) {
    echo json_encode([
        'success' => false,
        'data' => 'Este curso no soporta en enrolamiento manual'
    ]); 
}
        
if ($course instanceof stdClass) {
    $coreCourseList = new core_course_list_element($course);
} else {
    $coreCourseList = [];
}
        
$courseimage = null;
foreach ($coreCourseList->get_course_overviewfiles() as $file)
{
    $isimage = $file->is_valid_image();
    if($isimage) {

        if($file) {
            $courseimage = [
                'filename'  => $file->get_filename(),
                'filesize'  => $file->get_filesize(),
                'content'   => base64_encode($file->get_content()),
            ];

        }
    }
    
    
}


echo json_encode([
    'success' => true, 
    'data' => 
    [
        'courseid' => $course->id,
        'courseimage' => $courseimage,
        'enddate' => $course->enddate,
        'fullname' => $course->fullname,
        'idnumber' => $course->idnumber,
        'shortname' => $course->shortname,
        'startdate' => $course->startdate,
        'summary' => $course->summary,
    ]
]);




