<?php
defined('MOODLE_INTERNAL') || die();

$THEME->name = 'universe_child';
$THEME->parents = ['universe'];

require_once(__DIR__ . '/lib.php');

$THEME->sheets = [
    'styles',
    'header',
    'quiz',
    'mobile',
    'message-page',
    'navbar',
    'assign',
    'course-catalog',
    'drawer-left',
    'topbar',
    'forum-list',
    'calendar',
    'progress',
    'my-index',
    'mod-forum',
    'comment-block',
    'feedback-block',
    'login',
    'incourse',
    'course-edit',
    'admin-user'
];
$THEME->editor_sheets = [];
$THEME->enable_dock = false;
$THEME->yuicssmodules = array();
$THEME->requiredblocks = '';
$THEME->rendererfactory = 'theme_overridden_renderer_factory';
$THEME->addblockposition = BLOCK_ADDBLOCK_POSITION_FLATNAV;
$THEME->hidefromselector = false;
$THEME->extrascsscallback = 'theme_universe_child_get_extra_scss';
$THEME->iconsystem = core\output\icon_system::FONTAWESOME;

$THEME->haseditswitch = true;

$THEME->scss = function ($theme) {
    return theme_universe_child_get_main_scss_content($theme);
};

$THEME->prescsscallback = 'theme_universe_child_get_pre_scss';

$THEME->layouts = [
    'incourse' => array(
        'file' => 'tmpl-incourse.php',
        'regions' => array('side-pre'),
        'defaultregion' => 'side-pre',
    ),
];
