require(["jquery", "core/ajax"], function (
  $,
  ajax
) {
  const currentUrl = new URL(window.location.href);
  const params = currentUrl.searchParams;

  const page = params.get('page') ?? 1;

  $(document).ready(function () {
    $.fn.reloadBlockCursosCatalogoAjax = function () {
      $("#list-block-cursos-catalogo-ajax").empty();
      ajax
        .call([
          {
            methodname: "block_cursos_catalogo_ajax_list",
            args: {
              category_id: $(
                "#form-block-cursos-catalogo-ajax #category_id"
              ).val(),
              search_text: $(
                "#form-block-cursos-catalogo-ajax #search_text"
              ).val(),
              page: page,
            },
          },
        ])[0]
        .done(function (response) {
          var json = JSON.parse(response);

          if (json.success) {
            console.log(json.cards);

            $("#list-block-cursos-catalogo-ajax").html(json.cards);

            console.log(json.badges);
            $("#list-block-cursos-catalogo-ajax-course-badges").html(
              json.badges
            );
          }
          return;
        })
        .fail(function (err) {
          console.log(err);
          return;
        });
    };

    $(
      "#form-block-cursos-catalogo-ajax #category_id, #form-block-cursos-catalogo-ajax #search_text"
    ).change(function (e) {
      e.preventDefault();
      $.fn.reloadBlockCursosCatalogoAjax();
    });

    $("#form-block-cursos-catalogo-ajax").on("submit", function (e) {
      e.preventDefault();
      $.fn.reloadBlockCursosCatalogoAjax();
      return false;
    });

    $("body").on("click", "span.course-badge", function (e) {
      e.preventDefault();

      $("#form-block-cursos-catalogo-ajax #category_id").val(
        $(this).data("id")
      );
      $.fn.reloadBlockCursosCatalogoAjax();
    });

    $("body").on("click", "a.btn-autoenrol", function (e) {
      e.preventDefault();
      var courseid = $(this).data("courseid");
      var viewurl = $(this).data("viewurl");

      ajax
        .call([
          {
            methodname: "block_cursos_catalogo_ajax_enrol",
            args: {
              courseid: courseid,
            },
          },
        ])[0]
        .done(function (response) {
          var json = JSON.parse(response);
          console.log(json);

          if (json.success) {
            window.location.href = viewurl;
          } else {
            alert(json.data);
          }
          return;
        })
        .fail(function (err) {
          console.log(err);
          return;
        });
    });

    $.fn.reloadBlockCursosCatalogoAjax();
  });
});
