<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Settings for the cesa_notes block
 *
 * @package    block_cesa_notes
 * @author     Gautam Kumar Das<gautam.arg@gmail.com>
 */

defined('MOODLE_INTERNAL') || die;

if ($ADMIN->fulltree) {

    $perpageoptions = array();
    for ($i = 1; $i < 20; $i++) {
        $perpageoptions[$i] = $i;
    }
    $settings->add(new admin_setting_configselect('block_cesa_notes/cesa_notesperpage', get_string('cesa_notesperpage', 'block_cesa_notes'),
                       get_string('cesa_notesperpage_help', 'block_cesa_notes'), 5, $perpageoptions));

    $settings->add(new admin_setting_configtext('block_cesa_notes/characterlimit', get_string('characterlimit', 'block_cesa_notes'),
                       get_string('characterlimit_help', 'block_cesa_notes'), 180, PARAM_INT, 3));

    $positionoptions = array();
    $positionoptions['cesa_notes-pos-rb'] = get_string('bottomright', 'block_cesa_notes');
    $positionoptions['cesa_notes-pos-lb'] = get_string('bottomleft', 'block_cesa_notes');
    $positionoptions['cesa_notes-pos-rt'] = get_string('topright', 'block_cesa_notes');
    $positionoptions['cesa_notes-pos-lt'] = get_string('topleft', 'block_cesa_notes');
    $settings->add(new admin_setting_configselect('block_cesa_notes/icondisplayposition', get_string('icondisplayposition', 'block_cesa_notes'),
                       get_string('icondisplayposition_help', 'block_cesa_notes'), 'cesa_notes-pos-rb', $positionoptions));
}