<?php

require_once('../../config.php');
require_once($CFG->dirroot.'/course/lib.php');
require_once($CFG->dirroot . '/blocks/cesa_notes/lib.php');
require_once('./lib/fpdf/fpdf.php');

class PDF extends FPDF
{
// Cabecera 
function Header()
{

    $this->Image('./pix/header.png',10,8,20);
    $this->SetFont('Arial','B',15);
    $this->Cell(80);
    $this->Cell(30,15,get_string('cesa_notes', 'block_cesa_notes'),0,0,'C');

    $this->Ln(50);
}

// Pie de página
function Footer()
{
    // Posición: a 1,5 cm del final
    $this->SetY(-15);
    $this->Image('./pix/footer.png',10,null,190);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Número de página
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
}
}

$manager = new block_cesa_notes_manager();
$notes = $manager->get_notes_to_print();

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Times','',12);
foreach($notes as $note) {
    
    $pdf->SetFont('Arial');
    $pdf->SetFontSize(10);
    $pdf->SetTextColor(255,2555,255);
    $pdf->SetFillColor(58, 174, 219);
    if ($note->courseid != 1) {
        $pdf->Cell(0,6, utf8_decode($note->coursename . ' - ' . $note->modulename),'LTR',1,'L',1);
        $pdf->Cell(0,6, $note->timecreated,'LRB',1,'L',1);
    } else {
        $pdf->Cell(0,6, $note->timecreated,1,1,'L',1);
    }
    $pdf->SetTextColor(38,38,38);
    $pdf->SetFontSize(16);
    $pdf->MultiCell(0, 10, utf8_decode($note->content), 1);
    $pdf->Ln(10);
}

$pdf->Output();
    
