<?php
defined('MOODLE_INTERNAL') || die();

use core_completion\progress;

global $CFG;
require_once $CFG->libdir  . '/externallib.php';
require_once $CFG->dirroot . '/course/classes/category.php';
require_once $CFG->dirroot . '/blocks/moodleblock.class.php';
require_once $CFG->dirroot . '/blocks/course_list/block_course_list.php';



class block_cursos_catalogo_ajax_external extends \external_api
{
    
    public static function enrolar_usuario_cursos_catalogo_parameters()
    {
        return new \external_function_parameters([
            'courseid' => new \external_value(PARAM_INT, 'ID del curso', VALUE_DEFAULT, 0),
        ]);
    }
    
    public static function enrolar_usuario_cursos_catalogo($courseid)
    {
        global $USER, $DB, $CFG;
        
        
        $userid = $USER->id;
        $course = get_course($courseid);
        $enrol = true;
        
        if(!$course) {
            return json_encode(['success' => false, 'data' => 'No existe el curso']);
        }
        
        
        $enrolmethod = 'self';
        
        $instance = $DB->get_record('enrol', ['courseid' => $course->id, 'enrol' => $enrolmethod, 'status' => 0]);
        if(!$instance) {
            return json_encode(['success' => false, 'data' => 'El curso no permite auto inscribirse']);
            
        }
        
        try { 
        $user = $DB->get_record('user', ['id' => $userid]);
        $role = $DB->get_record('role', array('archetype' => 'student'));
        $context = context_course::instance($course->id);

        $context = context_course::instance($course->id);
        if (is_enrolled($context, $user)) {
            return json_encode(['success' => true]);
            
        } else {
            $enrol = enrol_get_plugin($enrolmethod);
            if ($enrol === null) {
                return false;
            }
            $instances = enrol_get_instances($course->id, true);
            $manualinstance = null;
            foreach ($instances as $instance) {
                if ($instance->name == $enrolmethod) {
                    $manualinstance = $instance;
                    break;
                }
            }
            if ($manualinstance !== null) {
                $instanceid = $enrol->add_default_instance($course);
                if ($instanceid === null) {
                    $instanceid = $enrol->add_instance($course);
                }
                $instance = $DB->get_record('enrol', array('id' => $instanceid));
            }
            $enrol->enrol_user($instance, $user->id, $role->id);
        }
   
        return json_encode(['success' => true]);
        
        } catch(\Exception $e) {
            error_log($e->getTraceAsString());
            
            return json_encode(['success' => false, 'data' => $e->getMessage()]);
        }
        
        
        
       
    }
    
    
    public static function enrolar_usuario_cursos_catalogo_returns()
    {
        return new \external_value(PARAM_RAW, 'The updated JSON output');
        
    }
    
    
    
    public static function get_cursos_catalogo_parameters()
    {
        return new \external_function_parameters([
            'category_id' => new \external_value(PARAM_INT, 'Categoría de los Cursos', VALUE_DEFAULT, 0),
            'search_text' => new \external_value(PARAM_ALPHANUM, 'Palabra de busqueda', VALUE_DEFAULT, ' ' ),
        ]);
    }

    public static function get_cursos_catalogo($category_id, $search_text)
    {

        /*
        [
        'category_id' => $category_id,
        'search_text' => $search_text,
        ] = self::validate_parameters(self::execute_parameters(), [
            'category_id' => $category_id,
            'search_text' => $search_text
        ]);
        */
        
        global $USER, $DB, $CFG, $OUTPUT, $PAGE;
        


        $userid = $USER->id;
        $url_noimage =  $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';

        $is_admin = false;
        $admins = get_admins();
        foreach($admins as $admin)
        {
            if($USER->id == $admin->id) {
                $is_admin = true;
                break;
            }
        }
        
        $company = $DB->get_record('company', ['hostname' => $_SERVER["SERVER_NAME"]]);
        
        
        $course_ids                 = [];
        $categories                 = []; 
        $category_ids               = [];
        $courseAvailableForAutoRol  = [];
        
        
        if($is_admin) {
            $mycourses = get_courses();
            foreach ($mycourses as $course)
            {
                if(!$course->visible) {
                    continue;
                }
                
                if(!in_array($category_ids)) {
                    
                    $category_ids[] = $course->category;
                    
                    $category = $DB->get_record('course_categories',array('id'=> $course->category));
                    if(!$category) {
                        continue;
                    }
                    
                    if(!$category->visible) {
                        continue;
                    }
                    
                    $categories[$category->id] = $category->name;
                    if(!in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                    }
                } else {
                    if(isset($categories[$course->category]) && !in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                    }
                }
            }
            
        } else {
            $mycourses  = enrol_get_users_courses($USER->id);
            foreach ($mycourses as $course)
            {
                if(!$course->visible) {
                    continue;
                }
                
                if(!in_array($category_ids)) {
                    
                    $category_ids[] = $course->category;
                    
                    $category = $DB->get_record('course_categories',array('id'=> $course->category));
                    if(!$category) {
                        continue;
                    }
                    
                    if(!$category->visible) {
                        continue;
                    }
                    
                    $categories[$category->id] = $category->name;
                    if(!in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                    }
                } else {
                    if(isset($categories[$course->category]) && !in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                    }
                }
            }
            
            
            $courses_with_autoenrol  = $DB->get_records('enrol', ['enrol' => 'self', 'status' => 0]);
            

            foreach($courses_with_autoenrol as $course_with_autoenrol)
            {
                $course = get_course($course_with_autoenrol->courseid);
                if(!$course->visible) {
                    continue;
                }
                
                
                $company_course  = $DB->get_record('company_course', ['courseid' => $course_with_autoenrol->courseid]);
                if($company_course) {
                    
                    if(!$company) {
                        continue;
                    }

                    if($company_course->companyid != $company->id) {
                        continue;
                    }
                    
                } else {
                    if($company) {
                        continue;
                    }
                }

                
                if(!in_array($category_ids)) {
                    
                    $category_ids[] = $course->category;
                    
                    $category = $DB->get_record('course_categories',array('id'=> $course->category));
                    if(!$category) {
                        continue;
                    }
                    
                    if(!$category->visible) {
                        continue;
                    }
                    
                    $categories[$category->id] = $category->name;
                    if(!in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                        $courseAvailableForAutoRol[] = $course->id;
                    }
                } else {
                    if(isset($categories[$course->category]) && !in_array($course->id, $course_ids)) {
                        $course_ids[] = $course->id;
                        $courseAvailableForAutoRol[] = $course->id;
                    }
                }
                
            }
        }
        

        
        
  
        $mycourses = [];
        foreach ($course_ids as $courseid)
        {
            $course = get_course($courseid);
            if($search_text) {
                if(stripos($course->fullname, $search_text) === false) {
                    continue;
                }
            }
            
            if($category_id) {
                if($category_id != $course->category) {
                    continue;
                }
            }
            
            array_push($mycourses, $course);
        }
        

        asort($mycourses, function($a, $b) {
            return trim($a['fullname']) <=> trim($b['fullname']); 
        });
        
        $courses = [];
        foreach ($mycourses as $course) 
        {
            if ($course instanceof stdClass) {
                $coreCourseList = new core_course_list_element($course);
            }
            $image = $url_noimage;
            foreach ($coreCourseList->get_course_overviewfiles() as $file)
            {
                $isimage = $file->is_valid_image();
                $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), !$isimage);
                if (!$isimage) {
                    $image = $url_noimage;
                }
            }
            
            $lastaccess = null;
            $sql = "select timecreated  from {logstore_standard_log} where courseid  = :courseid and userid  = :userid " .
                "  and eventname  = '\\\\core\\\\event\\\\course_viewed' order by id desc limit 1 ";
            
            $timecreated = $DB->get_field_sql($sql,  array('courseid' => $course->id, 'userid' => $userid));
            if($timecreated) {
                
                $lastaccess = date('d/m/Y h:i a', $timecreated);
            }
            
            $first_section = 0;
            $sections = $DB->get_records('course_sections', ['course' => $course->id], 'section ASC', 'id,name,section,sequence,visible');
            
            foreach($sections as $section)
            {
                if(!empty($section->section)) {
                    $first_section = $section->id;
                    break;
                }
            }
            $course_context = context_course::instance($course->id);
            $roles = get_user_roles($course_context, $USER->id, true);
            
            $completion_edit_curso = false;
            foreach ($roles as $role) {
                if ($role->shortname == 'companydepartmentmanager' || $role->shortname == 'companycoursenoneditor') {
                    $completion_edit_curso  = true;
                    break;
                }
            }
            
            if (has_capability('moodle/course:manageactivities', $course_context, $USER->id) || has_capability('moodle/course:viewhiddenactivities', $course_context, $USER->id) || $completion_edit_curso) {
                $editurl = $CFG->wwwroot . '/course/view.php?id='.$course->id.'&notifyeditingon=1';
            } else {
                $editurl = '';
            }
            
            
            $modules = get_fast_modinfo($course->id)->get_cms();
            
            $linkurl = '';
            foreach ($modules as $module)
            {
                if (!$module->uservisible || $module->is_stealth() || empty($module->url) || empty($module->section)) {
                    continue;
                }
                
                if($module->section == $first_section || $completion_edit_curso) {
                    $linkurl =  new moodle_url($module->url, array('forceview' => 1));
                    break;
                }
            }
            
            $summary = trim(strip_tags($course->summary));
            
            if(empty($summary)) {
                $summary = '<p></p>';
            } else if(strlen($summary) > 80) {
                
                $summary =  substr($summary, 0, 80) . '...';
            } 
            
            
            if(empty($editurl) && in_array($course->id, $courseAvailableForAutoRol)) {
                $autoenrol = 'yes';
            } else {
                $autoenrol = '';
            } 
            
            $courses[] = [
                'courseid' => $course->id,
                'coursecategory' => $categories[$course->category],
                'courseimage' => $image,
                'enddate' => $course->enddate,
                'fullname' => $course->fullname,
                'fullnamedisplay' => get_course_display_name_for_list($course),
                'hidden' => false,
                'id' => $course->id,
                'idnumber' => $course->idnumber,
                'isfavourite' => false,
                'shortname' => $course->shortname,
                'showshortname' => false,
                'startdate' => $course->startdate,
                'summary' =>  $summary,
                'summaryformat' => $course->summaryformat,
                'timeaccess' => $lastaccess,
                'viewurl' => $linkurl,
                'editurl' => $editurl,
                'autoenrol' => $autoenrol,
                'visible' => true,
            ];
            
            
        }
        

        
        $data = [
            'courses' => $courses 
        ]; 
        
        $cards = $OUTPUT->render_from_template('block_cursos_catalogo_ajax/cards', $data);
        

        return json_encode(['success' => true, 'search_text' => $search_text, 'category_id' => $category_id,  'cards' => $cards]);

    }
    

    public static function get_cursos_catalogo_returns()
    {
        return new \external_value(PARAM_RAW, 'The updated JSON output');

    }
 
    
    
    
    
    
    
    
}