<?php
defined('MOODLE_INTERNAL') || die();

use core_completion\progress;

// Definición de la clase que extiende plugin_renderer_base
class block_cesa_lastcourse_renderer extends plugin_renderer_base
{
    public function procesar()
    {
        global $USER, $DB, $CFG, $PAGE;

        $userid = $USER->id;
        $url_noimage =  $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';

        $data = ['course' => ''];

        // Consulta SQL optimizada para obtener el último curso accedido por el usuario
        $sql = "SELECT *
        FROM {logstore_standard_log}
        WHERE (eventname LIKE :courseviewedevent OR eventname LIKE :moduleviewedevent) 
        AND userid = :userid
        ORDER BY timecreated DESC
        LIMIT 1";
        $params = array('courseviewedevent' => '%course_viewed%', 'moduleviewedevent' => '%course_module_viewed%', 'userid' => $userid);
        $lastcourse = $DB->get_record_sql($sql, $params);

        if ($lastcourse) {
            $course = get_course($lastcourse->courseid);

            if ($course) {
                if ($course instanceof stdClass) {
                    $courseInList = new core_course_list_element($course);
                }

                // Obtener la imagen del curso o usar la imagen por defecto
                $image = $url_noimage;
                foreach ($courseInList->get_course_overviewfiles() as $file) {
                    $isimage = $file->is_valid_image();
                    $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), ! $isimage);
                    if (! $isimage) {
                        $image = $url_noimage;
                    }
                }

                // Obtener el último acceso al curso por el usuario
                $sql = "SELECT timecreated FROM {logstore_standard_log} WHERE courseid = :courseid AND userid = :userid ";
                $sql .= "AND eventname = '\\\\core\\\\event\\\\course_viewed' ORDER BY id DESC LIMIT 1";
                $timecreated = $DB->get_field_sql($sql, ['courseid' => $course->id, 'userid' => $userid]);
                $lastaccess = $timecreated ? date('d/m/Y h:i a', $timecreated) : null;

                // Obtener el progreso del usuario en el curso
                $progress = progress::get_course_progress_percentage($course);
                $progress = $progress ? floatval($progress) : 0.0;
                $miProgreso = number_format($progress, 2);

                // Verificar roles del usuario en el curso
                $course_context = context_course::instance($course->id);
                $roles = get_user_roles($course_context, $USER->id, true);
                $completion_edit_curso = false;
                foreach ($roles as $role) {
                    if ($role->shortname == 'companydepartmentmanager' || $role->shortname == 'companycoursenoneditor') {
                        $completion_edit_curso = true;
                        break;
                    }
                }

                // Si el usuario tiene ciertos roles, forzar la URL al curso
                if ($completion_edit_curso) {
                    $linkurl = $CFG->wwwroot . '/course/view.php?id=' . $course->id;
                }

                // Obtener la primera sección visible del curso
                $first_section = 0;
                $sections = $DB->get_records('course_sections', ['course' => $course->id], 'section ASC', 'id,name,section,sequence,visible');
                foreach ($sections as $section) {
                    if (!empty($section->section)) {
                        $first_section = $section->id;
                        break;
                    }
                }

                // Obtener el primer módulo visible del curso
                $modules = get_fast_modinfo($course->id)->get_cms();
                $linkurl = '';
                foreach ($modules as $module) {
                    if (!$module->uservisible || $module->is_stealth() || empty($module->url) || empty($module->section)) {
                        continue;
                    }

                    if ($module->section == $first_section || $completion_edit_curso) {
                        $linkurl = new moodle_url($module->url, ['forceview' => 1]);
                        break;
                    }
                }

                // Obtener categoría
                $category = $DB->get_record('course_categories', ['id' => $course->category]);

                // Obtener un resumen del curso
                $summary = trim(strip_tags($course->summary));
                if (empty($summary)) {
                    $summary = '&nbsp';
                } elseif (strlen($summary) > 80) {
                    $summary = substr($summary, 0, 80) . '...';
                }

                // Asignar datos del curso al array de respuesta
                $data['course'] = [
                    'courseid' => $course->id,
                    'coursecategory' => $category->name,
                    'courseimage' => $image,
                    'enddate' => $course->enddate,
                    'fullname' => $course->fullname,
                    'fullnamedisplay' => get_course_display_name_for_list($course),
                    'hasprogress' => true,
                    'hidden' => false,
                    'id' => $course->id,
                    'idnumber' => $course->idnumber,
                    'isfavourite' => false,
                    'progress' => $miProgreso,
                    'shortname' => $course->shortname,
                    'showshortname' => false,
                    'startdate' => $course->startdate,
                    'summary' => $summary,
                    'summaryformat' => $course->summaryformat,
                    'timeaccess' => $lastaccess,
                    'viewurl' => $CFG->wwwroot . '/course/view.php?id=' . $course->id,
                    'viewurlnew' => $linkurl,
                    'visible' => true,
                ];
            }
        } else {
            $data["course"] = [
                'fullname' => "Sin respuesta de la base de datos"
            ];
        }

        // Renderizar la plantilla con los datos del curso
        return $this->render_from_template('block_cesa_lastcourse/full', $data);
    }
}
