<?php

class block_cesa_course_rating extends block_base
{


  public function init()
  {
    $this->title = get_string('pluginname', 'block_cesa_course_rating');
  }

  public function applicable_formats()
  {

    return [
      'all' => false,
      'my' => false,
      'admin' => false,
      'course' => true,
      'incourse' => true,
      'course-view' => true,
      'enrol' => true,
    ];
  }

  function specialization()
  {
    global $CFG, $DB;
    if (empty($this->config)) {
      $this->instance->defaultregion = 'side-pre';
      $this->instance->region = 'side-pre';
      $DB->update_record('block_instances', $this->instance);

      $this->title = 'Puntuación del Curso';
    } else {
      $this->title = get_string('pluginname', 'block_cesa_course_rating');
    }
  }

  function instance_allow_multiple()
  {
    return false;
  }

  public function html_attributes()
  {
    global $CFG;
    $attributes = parent::html_attributes();

    /*
      $ccn_mt = '';
      $ccn_mb = '';
      $ccn_pt = '';
      $ccn_pb = '';
      $ccn_css_class = '';
      
      if(!empty($this->config->ccn_margin_top)){
          if($this->config->ccn_margin_top == '0') {
              $ccn_mt = '';
          } elseif($this->config->ccn_margin_top == 'zero') {
              $ccn_mt = 'margin-top:0px;';
          } else {
              $ccn_mt = 'margin-top:'.$this->config->ccn_margin_top.'px;';
          }
      }
      if(!empty($this->config->ccn_margin_bottom)){
          $ccn_mb = 'margin-bottom:'.$this->config->ccn_margin_bottom.'px;';
      } else {
          $ccn_mb = '';
      }
      if(!empty($this->config->ccn_padding_top)){
          $ccn_pt = 'padding-top:'.$this->config->ccn_padding_top.'px;';
      } else {
          $ccn_pt = '';
      }
      if(!empty($this->config->ccn_padding_bottom)){
          $ccn_pb = 'padding-bottom:'.$this->config->ccn_padding_bottom.'px;';
      } else {
          $ccn_pb = '';
      }
      if(!empty($this->config->ccn_css_class)){
          $ccn_css_class = $this->config->ccn_css_class;
      } else {
          $ccn_css_class = '';
      }
      
      
      $ccn_stylize = $ccn_mt . $ccn_mb . $ccn_pt . $ccn_pb;
      
      
      
      
      
      $attributes['ccn_style'] = $ccn_stylize;
      // $attributes['class'] .= ' block_'. $this->name();
      $attributes['class'] .= ' '. $ccn_css_class;
      */


    return $attributes;
  }

  public function has_config()
  {
    return true;
  }

  public function get_content()
  {
    global $CFG, $COURSE;

    if ($this->content !== null) {
      // return $this->content;
    }

    $this->content = new stdClass;

    if (!empty($this->config->title)) {
      $this->content->title =  format_text($this->config->title, FORMAT_HTML, array('filter' => true));
    } else {
      $this->content->title = get_string('pluginname', 'block_cesa_course_rating');
    }

    $courseid = $COURSE->id;
    $context = get_context_instance(CONTEXT_COURSE, $courseid);

    $canRate = has_capability('block/cesa_course_rating:rate', $context);
    if ($canRate == 1) {
      $canRateClass = 'ccn-can-rate';
    } else {
      $canRateClass = 'ccn-cannot-rate';
    }

    $ccnSubmitRating = $this->submit_rating();
    $this->content->text = '';

    $ccnRating    = number_format($this->overall_rating($COURSE->id), 1);

    $ccnStar      = '<li class="list-inline-item"><i class="fa fa-star"></i></li>';
    $ccnStarHalf  = '<li class="list-inline-item"><i class="fa fa-star-half-o"></i></li>';
    $ccnStarVoid  = '<li class="list-inline-item"><i class="fa fa-star-o"></i></li>';

    if ($ccnRating == 5) {
      $ccnStars = str_repeat($ccnStar, 5);
    } elseif ($ccnRating == 4.5) {
      $ccnStars = str_repeat($ccnStar, 4) . str_repeat($ccnStarHalf, 1);
    } elseif ($ccnRating == 4) {
      $ccnStars = str_repeat($ccnStar, 4) . str_repeat($ccnStarVoid, 1);
    } elseif ($ccnRating == 3.5) {
      $ccnStars = str_repeat($ccnStar, 3) . str_repeat($ccnStarHalf, 1) . str_repeat($ccnStarVoid, 1);
    } elseif ($ccnRating == 3) {
      $ccnStars = str_repeat($ccnStar, 3) . str_repeat($ccnStarVoid, 2);
    } elseif ($ccnRating == 2.5) {
      $ccnStars = str_repeat($ccnStar, 2) . str_repeat($ccnStarHalf, 1)  . str_repeat($ccnStarVoid, 2);
    } elseif ($ccnRating == 2) {
      $ccnStars = str_repeat($ccnStar, 2) . str_repeat($ccnStarVoid, 3);
    } elseif ($ccnRating == 1.5) {
      $ccnStars = str_repeat($ccnStar, 1) . str_repeat($ccnStarHalf, 1)  . str_repeat($ccnStarVoid, 3);
    } elseif ($ccnRating == 0.5) {
      $ccnStars = str_repeat($ccnStarHalf, 1) . str_repeat($ccnStarVoid, 4);
    } else {
      $ccnStars = str_repeat($ccnStarVoid, 5);
    }

    $ccnFive = $this->get_specific_average($COURSE->id, 5);
    $ccnFour = $this->get_specific_average($COURSE->id, 4);
    $ccnThree = $this->get_specific_average($COURSE->id, 3);
    $ccnTwo = $this->get_specific_average($COURSE->id, 2);
    $ccnOne = $this->get_specific_average($COURSE->id, 1);

    $this->content->text .= '
        	<div class="cs_row_five">
									<div class="student_feedback_container">
										<h4 data-ccn="title" class="aii_title">' . $this->content->title . '</h4>
										<div class="s_feeback_content">
									        <ul class="skills">
									        	<li class="list-inline-item">' . get_string('stars_5', 'block_cesa_course_rating') . '</li>
									            <li class="list-inline-item progressbar1" data-width="' . $ccnFive . '" data-target="100">' . $ccnFive . '%</li>
									        </ul>
									        <ul class="skills">
									        	<li class="list-inline-item">' . get_string('stars_4', 'block_cesa_course_rating') . '</li>
									            <li class="list-inline-item progressbar2" data-width="' . $ccnFour . '" data-target="100">' . $ccnFour . '%</li>
									        </ul>
									        <ul class="skills">
									        	<li class="list-inline-item">' . get_string('stars_3', 'block_cesa_course_rating') . '</li>
									            <li class="list-inline-item progressbar3" data-width="' . $ccnThree . '" data-target="100">' . $ccnThree . '%</li>
									        </ul>
									        <ul class="skills">
									        	<li class="list-inline-item">' . get_string('stars_2', 'block_cesa_course_rating') . '</li>
									            <li class="list-inline-item progressbar4" data-width="' . $ccnTwo . '" data-target="100">' . $ccnTwo . '%</li>
									        </ul>
									        <ul class="skills">
									        	<li class="list-inline-item">' . get_string('stars_1', 'block_cesa_course_rating') . '</li>
									            <li class="list-inline-item progressbar5" data-width="' . $ccnOne . '" data-target="100">' . $ccnOne . '%</li>
									        </ul>
										</div>
										<div class="aii_average_review text-center ' . $canRateClass . '">
											<div class="av_content">
												<h2>' . $ccnRating . '</h2>
												<ul class="aii_rive_list mb0">
													' . $ccnStars . '
												</ul>
												<p>' . $this->count_ratings($COURSE->id) . '</p>';
    if ($canRate == 1) {
      $this->content->text .= $ccnSubmitRating;
    }
    $this->content->text .= '
											</div>
										</div>
									</div>
								</div>';
    return $this->content;
  }

  public function overall_rating($courseID)
  {
    global $CFG, $DB;
    $sql = "  SELECT AVG(rating) AS average
                  FROM {block_cesa_course_rating}
                  WHERE course = $courseID
               ";
    $totalAverage = -1;
    if ($getAverage = $DB->get_record_sql($sql)) {
      $totalAverage = round($getAverage->average * 2) / 2;
    }
    return $totalAverage;
  }

  public function count_ratings($courseID)
  {
    global $CFG, $DB;
    $countRecords = $DB->count_records('block_cesa_course_rating', array('course' => $courseID));
    $countRatings = '';
    if ($countRecords > 0) {
      $countRatings = get_string('rated_by', 'block_cesa_course_rating', $countRecords);
    } else {
      $countRatings = get_string('rated_by_none', 'block_cesa_course_rating');
    }
    return $countRatings;
  }
  public function count_ratings_external($courseID)
  {
    global $CFG, $DB;
    $countRecords = $DB->count_records('block_cesa_course_rating', array('course' => $courseID));
    return $countRecords;
  }

  public function get_specific_average($courseID, $rating)
  {
    global $CFG, $DB;
    $countOnlyRating        = $DB->count_records('block_cesa_course_rating', array('course' => $courseID, 'rating' => $rating));
    $countExcludingRating   = $DB->count_records_sql(
      "       SELECT COUNT(*)
                FROM {block_cesa_course_rating}
                WHERE course = $courseID
                AND rating <> $rating
        "
    );

    $countTotal             = $DB->count_records('block_cesa_course_rating', array('course' => $courseID));

    if ($countTotal == 0) {
      $result = '0';
    } else {
      $result = $countOnlyRating / $countTotal * 100;
    }
    return $result;
  }

  public function submit_rating()
  {
    global $CFG, $COURSE, $USER, $DB;

    $courseid = $COURSE->id;
    $userid = $USER->id;

    if ($DB->record_exists('block_cesa_course_rating', array('course' => $courseid, 'user' => $userid))) {
      // Mensaje indicando que ya ha puntuado el curso
      return '<div class="alert alert-info">' . get_string('already_rated', 'block_cesa_course_rating') . '</div>';
    }

    // Mostrar el formulario si no ha puntuado
    $context = get_context_instance(CONTEXT_COURSE, $courseid);
    $ccnStar = '<span class="fa fa-star"></span>';
    $return = '<form id="ccn-star-rate" method="post" action="' . $CFG->wwwroot . '/blocks/cesa_course_rating/rate_course.php">
                      <input name="id" type="hidden" value="' . $courseid . '" />
                      <div class="ccn-star-rate-inner">';
    for ($i = 1; $i <= 5; $i++) {
      $printCcnStar = str_repeat($ccnStar, $i);
      $label_text = $i == 1 ? ' estrella' : ' estrellas';
      $return .= ' <label for="stars-' . $i . '">' .
        '<input required type="radio" id="stars-' . $i . '" name="rating" value="' . $i . '" />' .
        $i . $label_text .
        '</label>';
    }
    $return .= '  </div>
                      <button class="btn btn-primary" type="submit">' . get_string('rate_course', 'block_cesa_course_rating') . '</button>
                    </form>';
    return $return;
  }

  public function external_star_rating($courseID)
  {

    $ccnStar      = '<li class="list-inline-item"><i class="fa fa-star"></i></li>';
    $ccnStarHalf  = '<li class="list-inline-item"><i class="fa fa-star-half-o"></i></li>';
    $ccnStarVoid  = '<li class="list-inline-item"><i class="fa fa-star-o"></i></li>';
    $ccnRating    = $this->overall_rating($courseID);

    if ($ccnRating == 5) {
      $ccnStars = str_repeat($ccnStar, 5);
    } elseif ($ccnRating == 4.5) {
      $ccnStars = str_repeat($ccnStar, 4) . str_repeat($ccnStarHalf, 1);
    } elseif ($ccnRating == 4) {
      $ccnStars = str_repeat($ccnStar, 4) . str_repeat($ccnStarVoid, 1);
    } elseif ($ccnRating == 3.5) {
      $ccnStars = str_repeat($ccnStar, 3) . str_repeat($ccnStarHalf, 1) . str_repeat($ccnStarVoid, 1);
    } elseif ($ccnRating == 3) {
      $ccnStars = str_repeat($ccnStar, 3) . str_repeat($ccnStarVoid, 2);
    } elseif ($ccnRating == 2.5) {
      $ccnStars = str_repeat($ccnStar, 2) . str_repeat($ccnStarHalf, 1)  . str_repeat($ccnStarVoid, 2);
    } elseif ($ccnRating == 2) {
      $ccnStars = str_repeat($ccnStar, 2) . str_repeat($ccnStarVoid, 3);
    } elseif ($ccnRating == 1.5) {
      $ccnStars = str_repeat($ccnStar, 1) . str_repeat($ccnStarHalf, 1)  . str_repeat($ccnStarVoid, 3);
    } elseif ($ccnRating == 0.5) {
      $ccnStars = str_repeat($ccnStarHalf, 1) . str_repeat($ccnStarVoid, 4);
    } else {
      $ccnStars = str_repeat($ccnStarVoid, 5);
    }

    $return = '<div class="ccn-external-stars">' . $ccnStars . '<li class="list-inline-item"><span>(' . $this->count_ratings_external($courseID) . ')</span></li></div>';
    return $return;
  }
}
