<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block8', get_string('settingsblock8', 'theme_universechild'));

$name = 'theme_universechild/displayblock8';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock8_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #8</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock8';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<div class="wrapper-fw">
<!-- Start item -->
<div class="row no-gutters mb-5 rui-card--colorized rui-rounded--lg" style="background-color: #ffddd7;">
<div class="col-xs-12 col-lg-6 rui-img-rounded--lg pl-0 pr-lg-6">
<img src="https://assets.rosea.io/universechild/demo/800x600.png" alt="pic #1" width="800" height="600" class="img-fluid">
</div>
<div class="col-xs-12 col-lg-6 d-flex flex-wrap align-content-center px-lg-6 mt-3 mt-lg-0">
<div>
<h3 class="lead-3">Engaging live sessions.</h3>
<p>Lorem ipsum was purposefully designed to have no meaning, but appear like real text, making it the perfect placeholder.</p>
<a href="#" class="btn btn-dark mt-3" target="_blank">Learn more</a>
</div>
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="row no-gutters mb-5 rui-card--colorized rui-rounded--lg" style="background-color: #feedba;">
<div class="col-xs-12 col-lg-6 d-flex flex-wrap align-content-center px-lg-6">
<div>
<h3 class="lead-3">Well-documented Moodle Theme</h3>
<p>According to McClintock, a 15th century typesetter likely scrambled part...</p>
<a href="#" class="btn btn-dark mt-3" target="_blank">Check the documentation</a>
</div>
</div>
<div class="col-xs-12 col-lg-6 rui-img-rounded--lg pr-0 pl-lg-6 mt-3 mt-lg-0">
<img src="https://assets.rosea.io/universechild/demo/800x600.png" alt="pic #2" width="800" height="600" class="img-fluid">
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="row no-gutters mb-5 rui-card--colorized rui-rounded--lg" style="background-color: #f0e1f3;">
<div class="col-xs-12 col-lg-6 rui-img-rounded--lg pl-0 pr-lg-6">
<img src="https://assets.rosea.io/universechild/demo/800x600.png" alt="pic #4" width="800" height="600" class="img-fluid">
</div>
<div class="col-xs-12 col-lg-6 d-flex flex-wrap align-content-center px-lg-6 mt-3 mt-lg-0">
<div>
<h3 class="lead-3">Lifetime updates!</h3>
<p>And anyways, as Cecil Adams reasoned, “Do you really, think graphic arts...</p>
<a href="#" class="btn btn-dark mt-3" target="_blank">Available courses</a>
</div>
</div>
</div>
<!-- End item -->
</div>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block8customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
