<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();


$page = new admin_settingpage('theme_universe_settingsfooter', get_string( 'settingsfooter', 'theme_universe'));

$name = 'theme_universe/footerfw';
$title = get_string('footerfw', 'theme_universe');
$description = get_string('footerfw_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/showfooterbuttons';
$title = get_string('showfooterbuttons', 'theme_universe');
$description = get_string('showfooterbuttons_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hfooterblocks';
$heading = get_string('hfooterblocks', 'theme_universe');
$title = get_string('hfooterblocks_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/footerblock1';
$title = get_string('footerblock1', 'theme_universe');
$description = get_string('footerblock1_desc', 'theme_universe');
$default = '<div class="row no-gutters text-sm-center text-md-left">
<div class="col-12 col-lg-5 pr-lg-5 mr-lg-5 my-sm-2 my-md-0">
<div class="d-flex justify-content-center justify-content-md-start">
<img src="https://assets.rosea.io/universe/demo/universe-logo-white.svg" width="66" height="40" class="img-fluid"/>
</div>
<h5 class="rui-footer-nav-title mt-3">universe</h5>
<p class="text-size-xs">
Powerful, fully responsive, and easy-to-use Moodle Theme.
Works with Moodle 4.1, 4.0.<br>
<a href="#" target="_blank" title="Documentation - Footer Customization">Theme Documentation</a>
</p>
<p class="text-size-xs">
Made in Poland
</p>
</div>
<div class="col-12 col-lg my-sm-2 my-md-0">
<h5 class="rui-footer-nav-title">Course</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#" target="_blank" title="Standard Course View">Standard Layout</a> </li>
<li> <a href="#" target="_blank" title="Tab Layout">Tab Layout</a>
<span class="badge-xs badge-primary ml-2">Demo</span> </li>
<li> <a href="#" target="_blank">Format Plugins</a> </li>
<li> <a href="#">Paid Course (PayPal, etc.)</a> </li>

</ul>
</div>
<div class="col-12 col-lg mt-sm-4 mt-lg-0">
<h5 class="rui-footer-nav-title">UI Elements</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#">Front Page Blocks</a> </li>
<li> <a href="#">Blocks - Header</a> </li>
<li> <a href="#">Blocks - Footer</a> </li>
<li> <a href="#">Grid Content</a> </li>
<li> <a href="#">List</a> </li>
<li> <a href="#">Team</a> </li>
<li> <a href="#">Stats</a> </li>
<li> <a href="#">FAQ</a> </li>
</ul>
</div>
<div class="col-12 col-lg mt-sm-4 mt-lg-0">
<h5 class="rui-footer-nav-title">More</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#">Icons</a> </li>
<li> <a href="#">Plugins support</a> </li>
<li> <a href="https://rosea.gitbook.io/universe/" target="_blank" title="Theme Doc">Theme Doc</a> </li>
</ul>
</div>
</div>
<br />To edit this block go to: Site administration - Appearance - universe - Footer - Footer Block #1';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/footerblock1hr';
$title = get_string('footerblock1hr', 'theme_universe');
$description = get_string('footerblock1hr_desc', 'theme_universe');
$default = '1';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/footerblock2';
$title = get_string('footerblock2', 'theme_universe');
$description = get_string('footerblock2_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/footerblock2hr';
$title = get_string('footerblock2hr', 'theme_universe');
$description = get_string('footerblock2hr_desc', 'theme_universe');
$default = '1';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/footerblock3';
$title = get_string('footerblock3', 'theme_universe');
$description = get_string('footerblock3_desc', 'theme_universe');
$default = 'To edit this block go to: Site administration - Appearance - universe - Footer - Footer Block #3
<small>Get this theme exclusively on ThemeForest. Check all available Moodle themes
<a href="https://rosea.io" class="underline--anim">rosea.io</a></small>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/footercopy';
$title = get_string('footercopy', 'theme_universe');
$description = get_string('footercopy_desc', 'theme_universe');
$default = '© <strong>2023</strong>
<br />To edit this block go to: Site administration - Appearance - universe - Footer - Footer Copy';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hfootercolors';
$heading = get_string('hfootercolors', 'theme_universe');
$title = get_string('hfootercolors_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorfooterbg';
$title = get_string('colorfooterbg', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorfooterborder';
$title = get_string('colorfooterborder', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorfootertext';
$title = get_string('colorfootertext', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorfooterlink';
$title = get_string('colorfooterlink', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorfooterlinkhover';
$title = get_string('colorfooterlinkhover', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$fileid = 'footerbgimg';
$name = 'theme_universe/footerbgimg';
$title = get_string('footerbgimg', 'theme_universe');
$description = get_string('footerbgimg_desc', 'theme_universe');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/footercustomcss';
$title = get_string('footercustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);


$name = 'theme_universe/hfootersocial';
$heading = get_string('hfootersocial', 'theme_universe');
$title = get_string('hfootersocial_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/showbasicinfolist';
$title = get_string('showbasicinfolist', 'theme_universe');
$description = get_string('showbasicinfolist_desc', 'theme_universe');
$default = '0';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Website.
$name = 'theme_universe/website';
$title = get_string('website', 'theme_universe');
$description = get_string('website_desc', 'theme_universe');
$default = 'Moodle Themes';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Website.
$name = 'theme_universe/cwebsiteurl';
$title = get_string('cwebsiteurl', 'theme_universe');
$description = get_string('cwebsiteurl_desc', 'theme_universe');
$default = 'https://rosea.io';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Mobile.
$name = 'theme_universe/mobile';
$title = get_string('mobile', 'theme_universe');
$description = get_string('mobile_desc', 'theme_universe');
$default = 'Mobile : +12 (34) 00123-45678';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Mail.
$name = 'theme_universe/mail';
$title = get_string('mail', 'theme_universe');
$description = get_string('mail_desc', 'theme_universe');
$default = 'sample@mail.com';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/showsociallist';
$title = get_string('showsociallist', 'theme_universe');
$description = get_string('showsociallist_desc', 'theme_universe');
$default = '0';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Facebook url setting.
$name = 'theme_universe/facebook';
$title = get_string('facebook', 'theme_universe');
$description = get_string('facebook_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Twitter url setting.
$name = 'theme_universe/twitter';
$title = get_string('twitter', 'theme_universe');
$description = get_string('twitter_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Linkdin url setting.
$name = 'theme_universe/linkedin';
$title = get_string('linkedin', 'theme_universe');
$description = get_string('linkedin_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Youtube url setting.
$name = 'theme_universe/youtube';
$title = get_string('youtube', 'theme_universe');
$description = get_string('youtube_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Instagram url setting.
$name = 'theme_universe/instagram';
$title = get_string('instagram', 'theme_universe');
$description = get_string('instagram_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Cutsom icons setting.
$name = 'theme_universe/customsocialicon';
$title = get_string('customsocialicon', 'theme_universe');
$description = get_string('customsocialicon_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
