<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_settingstopbar', get_string( 'settingstopbar', 'theme_universechild'));

// Prepare hide nodes options.
$hidenodesoptions = array(
    'home' => get_string('home'),
    'myhome' => get_string('myhome'),
    'courses' => get_string('mycourses')
);

// Setting: Hide nodes in primary navigation.
$name = 'theme_universechild/hidenodesprimarynavigation';
$title = get_string('hidenodesprimarynavigationsetting', 'theme_universechild', null, true);
$description = get_string('hidenodesprimarynavigationsetting_desc', 'theme_universechild', null, true);
$setting = new admin_setting_configmulticheckbox($name, $title, $description, array(), $hidenodesoptions);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/navbarlogobox';
$title = get_string('navbarlogobox', 'theme_universechild');
$description = get_string('navbarlogobox_desc', 'theme_universechild', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/topbareditmode';
$title = get_string('topbareditmode', 'theme_universechild');
$description = get_string('topbareditmode_desc', 'theme_universechild', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/topbarcustomhtml';
$title = get_string('topbarcustomhtml', 'theme_universechild');
$description = get_string('topbarcustomhtml_desc', 'theme_universechild', $a);
$default = '';
$setting = new admin_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

// Custom Logo.
$name = 'theme_universechild/hlogoarea';
$heading = get_string('hlogoarea', 'theme_universechild');
$title = get_string('hlogoarea_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/topbarlogoareaon';
$title = get_string('topbarlogoareaon', 'theme_universechild');
$description = get_string('topbarlogoareaon_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/customlogo';
$title = get_string('customlogo', 'theme_universechild');
$description = get_string('customlogo_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.png', '.jpg', '.svg', 'gif'));
$setting = new admin_setting_configstoredfile($name, $title, $description, 'customlogo', 0, $opts);
$page->add($setting);

$name = 'theme_universechild/customdmlogo';
$title = get_string('customdmlogo', 'theme_universechild');
$description = get_string('customdmlogo_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.png', '.jpg', '.svg', 'gif'));
$setting = new admin_setting_configstoredfile($name, $title, $description, 'customdmlogo', 0, $opts);
$page->add($setting);

$name = 'theme_universechild/customlogoandname';
$title = get_string('customlogoandname', 'theme_universechild');
$description = get_string('customlogoandname_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/customlogotxt';
$title = get_string('customlogotxt', 'theme_universechild');
$description = get_string('customlogotxt_desc', 'theme_universechild');
$default = 'universechild';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Additional Button next to the Log in button.
$name = 'theme_universechild/hadditionalbtn';
$heading = get_string('hadditionalbtn', 'theme_universechild');
$title = get_string('hadditionalbtn_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/topbaradditionalbtn';
$title = get_string('topbaradditionalbtn', 'theme_universechild');
$description = get_string('topbaradditionalbtn_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/stopbaradditionalbtn';
$title = get_string('stopbaradditionalbtn', 'theme_universechild');
$description = get_string('stopbaradditionalbtn_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/topbaradditionalbtnurl';
$title = get_string('topbaradditionalbtnurl', 'theme_universechild');
$description = get_string('topbaradditionalbtnurl_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Colors.
$name = 'theme_universechild/htopbarcolors';
$heading = get_string('htopbarcolors', 'theme_universechild');
$title = get_string('htopbarcolors_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colortopbarbg';
$title = get_string('colortopbarbg', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colortopbartext';
$title = get_string('colortopbartext', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colortopbarbtn';
$title = get_string('colortopbarbtn', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colortopbarbtntext';
$title = get_string('colortopbarbtntext', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colortopbarbtnhover';
$title = get_string('colortopbarbtnhover', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colortopbarbtnhovertext';
$title = get_string('colortopbarbtnhovertext', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
