<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block12introsubtitle = format_text(theme_universechild_get_setting('block12introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block12introtitle = format_text(theme_universechild_get_setting('block12introtitle'), FORMAT_HTML, array('noclean' => true));
$block12introcontent = format_text(theme_universechild_get_setting('block12introcontent'), FORMAT_HTML, array('noclean' => true));
$block12html = format_text(theme_universechild_get_setting('block12htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block12footer = format_text(theme_universechild_get_setting('block12footercontent'), FORMAT_HTML, array('noclean' => true));
$block12count = theme_universechild_get_setting('block12count');
$block12slidesperrow = theme_universechild_get_setting('block12slidesperrow');
$block12class = theme_universechild_get_setting('block12class');
$block12img = $PAGE->theme->setting_file_url("block12bg", "block12bg");
$block12css = theme_universechild_get_setting('block12customcss');

$block12customcss = '';

if (!empty($block12css)) {
    $block12customcss = ' style="' . $block12css . '"';
}

if (!empty($block12img)) {
    $block12customcss = ' style="background-image: url(' . $block12img . ');" ';
}

// Customm ID for the block.
$block12customid = theme_universechild_get_setting('block12id');
$fpblockid12 = 'block12';
if (!empty($block12customid)) {
    $fpblockid12 = $block12customid;
}
// End.

echo '<!-- Start Block 12-->';
echo '<div id="' . $fpblockid12 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--12 ' . $block12class . '"' . $block12customcss . '>';
if (!empty($block12introtitle) || !empty($block12introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block12introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block12introsubtitle . '</h4>';
}
if (!empty($block12introtitle)) {
    echo '<h3 class="rui-block-title">' . $block12introtitle . '</h3>';
}
if (!empty($block12introcontent)) {
    echo '<div class="rui-block-desc">' . $block12introcontent . '</div>';
}
if (!empty($block12introtitle) || !empty($block12introcontent)) {
    echo '</div>';
}
echo $block12html;
if (!empty($block12footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block12footer . '</div>';
}
echo '</div>';
if (theme_universechild_get_setting("displayhrblock12") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 12 -->';
