<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block9',
    get_string('settingsblock9', 'theme_universe'));

$name = 'theme_universe/displayblock9';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock9_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #9</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock9';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = 'Lorem ipsum dolor sit amet';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<!-- Start item -->
<div class="rui-fp-grid-content--2 wrapper-fw row mx-0 px-0">
<!-- Col #1 -->
<div class="rui-fp-content-box rui-fp-content-box--left col-lg-6 align-self-center">
<div class="rui-card--blank">
<div class="rui-icon-box rui-icon-box--white mb-3">
<svg width="32" height="32" viewBox="0 0 24 24" fill="none"
xmlns="http://www.w3.org/2000/svg">
<path d="M4.75 10L12 5.75L19.2501 10L12 14.25L4.75 10Z" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M12.5 10C12.5 10.2761 12.2761 10.5 12 10.5C11.7239 10.5 11.5 10.2761
11.5 10C11.5 9.72386 11.7239 9.5 12 9.5C12.2761 9.5 12.5 9.72386 12.5 10Z"
stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M6.75 11.5V16.25C6.75 16.25 8 18.25 12 18.25C16 18.25 17.25 16.25
17.25 16.25V11.5" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<h4 class="lead-3 mt-3">Buy universe &amp; Start Teaching Online</h4>
<p class="text-size-lg">I have highlighted some of universe features below! </p>
<ul class="rui-special-list rui-special-list--light">
<li>Compatible with Moodle 4.1 and 4.0</li>
<li>22+ Fully Customizable Blocks</li>
<li>Lifetime updates</li>
<li>Super friendly support</li>
<li>Translation Ready</li>
</ul>
<p class="text-size-sm mb-3">* $99 + tax for standard license.</p>
<a href="#" class="btn btn-dark">Check all Moodle Themes</a>
</div>
</div>
<!-- End Col #1 -->
<!-- Col #2 -->
<div class="rui-fp-content-box rui-img--rounded-right col-lg-6 p-0">
<div class="rui-img-box--anim">
<img src="https://assets.rosea.io/universe/demo/800x800.png" alt="pic" width="800" height="800" class="img-fluid">
</div>
</div>
<!-- End Col #2 -->
</div>
<!-- End item -->';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block9customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
