<?php

// Every file should have GPL and copyright in the header - we skip it in tutorials but you should not skip it for real.

// This line protects the file from being accessed by a URL directly.                                                               
defined('MOODLE_INTERNAL') || die();
require_once(__DIR__ . '/../universe/libs/admin_confightmleditor.php');
require_once($CFG->dirroot . '/theme/universe/lib.php');

$siteurl = $CFG->wwwroot;
$a = new stdClass;
$a->siteurl = $siteurl;

// This is used for performance, we don't need to know about these settings on every page in Moodle, only when                      
// we are looking at the admin settings pages.                                                                                      
if ($ADMIN->fulltree) {

    // Boost provides a nice setting page which splits settings onto separate tabs. We want to use it here.                         
    $settings = new theme_universe_admin_settingspage_tabs('themesettinguniverse_child', get_string('configtitle', 'theme_universe_child'));

    // Child theme specific settings
    $page = new admin_settingpage('theme_universe_child_specific', get_string('childthemesettings', 'theme_universe_child'));

    // Replicate the preset setting from boost.                                                                                     
    $name = 'theme_universe_child/preset';
    $title = get_string('preset', 'theme_universe_child');
    $description = get_string('preset_desc', 'theme_universe_child');
    $default = 'default.scss';

    // We list files in our own file area to add to the drop down. We will provide our own function to                              
    // load all the presets from the correct paths.                                                                                 
    $context = context_system::instance();
    $fs = get_file_storage();
    $files = $fs->get_area_files($context->id, 'theme_universe_child', 'preset', 0, 'itemid, filepath, filename', false);

    $choices = [];
    foreach ($files as $file) {
        $choices[$file->get_filename()] = $file->get_filename();
    }
    // These are the built in presets from Boost.                                                                                   
    $choices['default.scss'] = 'default.scss';
    $choices['plain.scss'] = 'plain.scss';

    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Preset files setting.                                                                                                        
    $name = 'theme_universe_child/presetfiles';
    $title = get_string('presetfiles', 'theme_universe_child');
    $description = get_string('presetfiles_desc', 'theme_universe_child');

    $setting = new admin_setting_configstoredfile(
        $name,
        $title,
        $description,
        'preset',
        0,
        array('maxfiles' => 20, 'accepted_types' => array('.scss'))
    );
    $page->add($setting);

    // Variable $brand-color.                                                                                                       
    // We use an empty default value because the default colour should come from the preset.                                        
    $name = 'theme_universe_child/brandcolor';
    $title = get_string('brandcolor', 'theme_universe_child');
    $description = get_string('brandcolor_desc', 'theme_universe_child');
    $setting = new admin_setting_configcolourpicker($name, $title, $description, '');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Raw SCSS to include before the content.                                                                                      
    $setting = new admin_setting_configtextarea(
        'theme_universe_child/scsspre',
        get_string('rawscsspre', 'theme_universe_child'),
        get_string('rawscsspre_desc', 'theme_universe_child'),
        '',
        PARAM_RAW
    );
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Raw SCSS to include after the content.                                                                                       
    $setting = new admin_setting_configtextarea(
        'theme_universe_child/scss',
        get_string('rawscss', 'theme_universe_child'),
        get_string('rawscss_desc', 'theme_universe_child'),
        '',
        PARAM_RAW
    );
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    $settings->add($page);

    // Advanced settings.                                                                                                           
    $page = new admin_settingpage('theme_universe_child_advanced', get_string('advancedsettings', 'theme_universe_child'));

    // Raw SCSS to include before the content.                                                                                      
    $setting = new admin_setting_configtextarea(
        'theme_universe_child/scsspre',
        get_string('rawscsspre', 'theme_universe_child'),
        get_string('rawscsspre_desc', 'theme_universe_child'),
        '',
        PARAM_RAW
    );
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    // Raw SCSS to include after the content.                                                                                       
    $setting = new admin_setting_configtextarea(
        'theme_universe_child/scss',
        get_string('rawscss', 'theme_universe_child'),
        get_string('rawscss_desc', 'theme_universe_child'),
        '',
        PARAM_RAW
    );
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    $settings->add($page);
}
