<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block21introsubtitle = format_text(theme_universe_get_setting('block21introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block21titlecolor = theme_universe_get_setting('block21titlecolor');
$block21titlesize = theme_universe_get_setting('block21titlesize');
$block21titleweight = theme_universe_get_setting('block21titleweight');

$block21introtitle = format_text(theme_universe_get_setting('block21introtitle'), FORMAT_HTML, array('noclean' => true));
$block21introcontent = format_text(theme_universe_get_setting('block21introcontent'), FORMAT_HTML, array('noclean' => true));
$block21html = format_text(theme_universe_get_setting('block21htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block21footer = format_text(theme_universe_get_setting('block21footercontent'), FORMAT_HTML, array('noclean' => true));
$block21css = theme_universe_get_setting('block21customcss');
$block21img = $PAGE->theme->setting_file_url("block21bg", "block21bg");
$block21textalign = theme_universe_get_setting('block21textalign');
$block21class = theme_universe_get_setting('block21class');

// Start Title - Color.
$block21titlecolorclass = null;
if ($block21titlecolor == 0) {
    $block21titlecolorclass = ' rui-text--white';
}

if ($block21titlecolor == 1) {
    $block21titlecolorclass = ' rui-text--black';
}

if ($block21titlecolor == 2) {
    $block21titlecolorclass = ' rui-text--gradient';
}
// End.

// Start Title - Weight.
$block21titleweightclass = null;
if ($block21titleweight == 0) {
    $block21titleweightclass = ' rui-text--weight-normal';
}

if ($block21titleweight == 1) {
    $block21titleweightclass = ' rui-text--weight-medium';
}

if ($block21titleweight == 2) {
    $block21titleweightclass = ' rui-text--weight-bold';
}
// End.

// Start Title - Size.
$block21titlesizeclass = null;
if ($block21titlesize == 1) {
    $block21titlesizeclass = '';
}

if ($block21titlesize == 1) {
    $block21titlesizeclass = ' rui-hero-title-lg';
}

if ($block21titlesize == 2) {
    $block21titlesizeclass = ' rui-hero-title-xl';
}
// End.

$block21customcss = '';
$custombg = '';

if (!empty($block21css)) {
    $block21customcss = $block21css;
}

// Customm ID for the block.
$block21customid = theme_universe_get_setting('block21id');
$fpblockid21 = 'block21';
if (!empty($block21customid)) {
    $fpblockid21 = $block21customid;
}
// End.

if (!empty($block21img)) {
    $custombg = ' background-image: url(' . $block21img . '); ';
}

echo '<!-- Start Block 21 -->';
echo '<div id="' . $fpblockid21 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--21 rui-rounded--lg d-flex align-items-center ' .
        $block21class . '" style="' . $block21customcss . $custombg .'">';
echo '<div class="rui-cta-wrapper--' .
            $block21textalign .
            ' text-' .
            $block21textalign .
            '">';

if (!empty($block23introtitle)) {
    echo '<h4 class="rui-cta-subtitle' .
        $block23titlecolorclass .
        $block23titleweightclass .
        '">' .
        $block23introsubtitle .
        '</h4>';
}

if (!empty($block21introtitle)) {
    echo '<h3 class="rui-cta-title' .
        $block21titlecolorclass .
        $block21titleweightclass .
        $block21titlesizeclass .
        '">' .
        $block21introtitle . '</h3>';
}

if (!empty($block21introcontent)) {
    echo '<div class="rui-cta-content' .
        $block21titlecolorclass .
        '">' .
        $block21introcontent .
        '</div>';
}

echo $block21html;

if (!empty($block21footer)) {
    echo '<div class="rui-cta-small">' . $block21footer . '</div>';
}

echo '</div>';
echo '</div>';
if (theme_universe_get_setting("displayhrblock21") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 21 -->';
