<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_general', get_string('generalsettings', 'theme_universe'));

$name = 'theme_universe/hintro';
$heading = get_string('hintro', 'theme_universe', $a);
$title = get_string('hintro_desc', 'theme_universe');
$setting = new universe_setting_specialsettingheading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/darkmodetheme';
$title = get_string('darkmodetheme', 'theme_universe');
$description = get_string('darkmodetheme_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/darkmodefirst';
$title = get_string('darkmodefirst', 'theme_universe');
$description = get_string('darkmodefirst_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/sdarkmode';
$title = get_string('sdarkmode', 'theme_universe');
$description = get_string('sdarkmode_desc', 'theme_universe');
$default = 'Dark Mode';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/slightmode';
$title = get_string('slightmode', 'theme_universe');
$description = get_string('slightmode_desc', 'theme_universe');
$default = 'Light Mode';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/showcolorcoursecardmask';
$title = get_string('showcolorcoursecardmask', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcheckbox($name, $title, $description, 'no', 'yes', 'no');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/themeauthor';
$title = get_string('themeauthor', 'theme_universe');
$description = get_string('themeauthor_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/backtotop';
$title = get_string('backtotop', 'theme_universe');
$description = get_string('backtotop_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Video Size
$name = 'theme_universe/forcefwvideo';
$title = get_string('forcefwvideo', 'theme_universe');
$description = get_string('forcefwvideo_desc', 'theme_universe', $a);
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Setting: Show hint for switched role.
$name = 'theme_universe/showswitchedroleincourse';
$title = get_string('showswitchedroleincoursesetting', 'theme_universe');
$description = get_string('showswitchedroleincoursesetting_desc', 'theme_universe', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Setting: Show hint in hidden courses.
$name = 'theme_universe/showhintcoursehidden';
$title = get_string('showhintcoursehiddensetting', 'theme_universe');
$description = get_string('showhintcoursehiddensetting_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Setting: Show hint guest for access.
$name = 'theme_universe/showhintcourseguestaccess';
$title = get_string('showhintcoursguestaccesssetting', 'theme_universe');
$description = get_string('showhintcourseguestaccesssetting_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Setting: Show hint for self enrolment without enrolment key.
$name = 'theme_universe/showhintcourseselfenrol';
$title = get_string('showhintcourseselfenrolsetting', 'theme_universe');
$description = get_string('showhintcourseselfenrolsetting_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Unaddable blocks.
$default = 'navigation,settings,course_list,section_links';
$setting = new admin_setting_configtext('theme_universe/unaddableblocks',
    get_string('unaddableblocks', 'theme_universe'), get_string('unaddableblocks_desc', 'theme_universe'), $default, PARAM_TEXT);
$page->add($setting);

// Google analytics block.
$name = 'theme_universe/googleanalytics';
$title = get_string('googleanalytics', 'theme_universe');
$description = get_string('googleanalyticsdesc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$settings->add($page);
