<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block12', get_string('settingsblock12', 'theme_universe'));

$name = 'theme_universe/displayblock12';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock12_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #12</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock12';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<div class="row row-cols-1 row-cols-md-3 row-cols-lg-4 text-center text-md-left">
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card-body d-inline-flex align-items-center">
<!-- icon -->
<div class="rui-rounded-icon mr-3" style="color: #000; background: #feedba;">
<svg width="32px" height="32px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M2 5h7m7 0h-2.5M9 5h4.5M9 5V3m4.5 2c-.82 2.735-2.539 5.32-4.5
7.593M4 17.5c1.585-1.359 3.376-3.026 5-4.907m0 0C8 11.5 6.4 9.3 6 8.5m3
4.093l3 2.907M13.5 21l1.143-3m6.857 3l-1.143-3m-5.714 0l2.857-7.5 2.857
7.5m-5.714 0h5.714" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="rui-card-title--light mb-0">Translation Ready</h3>
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card-body d-inline-flex align-items-center">
<!-- icon -->
<div class="rui-rounded-icon mr-3" style="color: #000; background: #feedba;">
<svg width="32px" stroke-width="1.5" height="32px" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M9 21H8c-1.105 0-2-.894-2-1.999V14c0-1-1.5-2-1.5-2S6 11 6 10V5a2 2
0 012-2h1M15 21h1c1.105 0 2-.894 2-1.999V14c0-1 1.5-2 1.5-2S18 11 18 10V5a2 2
0 00-2-2h-1" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="rui-card-title--light mb-0">Fully Customizable Blocks</h3>
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card-body d-inline-flex align-items-center">
<!-- icon -->
<div class="rui-rounded-icon mr-3" style="color: #000; background: #feedba;">
<svg width="32px" height="32px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M13.848 13.317L9.505 18.28a2 2 0 01-3.01 0l-4.343-4.963a2 2 0
010-2.634L6.495 5.72a2 2 0 013.01 0l4.343 4.963a2 2 0 010 2.634z"
stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
stroke-linejoin="round"></path>
<path d="M13 19l4.884-5.698a2 2 0 000-2.604L13 5" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M17 19l4.884-5.698a2 2 0 000-2.604L17 5" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="rui-card-title--light mb-0">Lifetime updates</h3>
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card-body d-inline-flex align-items-center">
<!-- icon -->
<div class="rui-rounded-icon mr-3" style="color: #000; background: #feedba;">
<svg width="32px" height="32px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M8 12l3 3 5-5" stroke="currentColor" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12c0 1.821.487
3.53 1.338 5L2.5 21.5l4.5-.838A9.955 9.955 0 0012 22z" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="rui-card-title--light mb-0">Super friendly support</h3>
</div>
</div>
<!-- End item -->
</div>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block12footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$fileid = 'block12bg';
$name = 'theme_universe/block12bg';
$title = get_string('blockbg', 'theme_universe');
$description = get_string('blockbg_desc', 'theme_universe');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/block12customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
