<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();
$siteurl = $CFG->wwwroot;

$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'A bootswatch is a set of Bootstrap variables and css to style Bootstrap';
$string['choosereadme'] = '<div class="rui-block-testimonials-item mt-2 mb-4"><div class="lead-3 w-100 mb-0">Hi, the Universe Moodle theme is here!</div><br />Have a nice day!</div>
<p class="small">Premium Moodle Theme designed by RoseaThemes.</p>
<div class="mt-4"><h4>Support</h4><p>Need help with theme customization?<br />or you want to report a bug?</p></div>
<a class="underline--anim mr-3" href="https://rosea.gitbook.io/universe-moodle-theme/" target="_blank" class="btn btn-sm btn-primary ml-0 mt-2 mb-2 mr-2">Online Documentation</a>
<a class="underline--anim" href="https://roseathemes.ticksy.com" target="_blank" class="btn btn-sm btn-secondary m-2">Dedicated ticket system</a>';
$string['currentinparentheses'] = '(current)';
$string['configtitle'] = 'Universe';
$string['hgeneralnav'] = 'Main navgation items';
$string['hgeneralnav_desc'] = 'Here you can turn off elements of the main navigation.';
$string['generalsettings'] = 'General settings';
$string['displaysitehome'] = 'Site home';
$string['displaydashboard'] = 'Dashboard';
$string['displaycalendar'] = 'Calendar';
$string['displayprivatefiles'] = 'Private files';
$string['displaycontentbank'] = 'Content Bank';
$string['displaynavitems_desc'] = '';

$string['nobootswatch'] = 'None';
$string['pluginname'] = 'Universe (1.3.2)';
$string['privacy:metadata'] = 'The universe theme does not store any personal data about any user.';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.
<a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/advanced-options/custom-css-scss-for-blocks" target="_blank" class="btn btn-sm btn-secondary m-2">Learn more</a>';
$string['rawscsspre'] = 'Raw initial SCSS';
$string['rawscsspre_desc'] = 'In this field you can provide initialising SCSS code, it will be injected before everything else. Most of the time you will use this setting to define variables.';

$string['empty_desc'] = '';

// Navigation improvements.
$string['myactivecourses'] = 'My active courses';
$string['coursesections'] = 'Course sections';

// Privacy.
$string['privacy:metadata:preference:sidebaropen'] = 'The user\'s preference for hiding or showing the right sidebar.';
$string['privacy:metadata:preference:darkmodeon'] = 'The user\'s preference for dark mode';
$string['privacy:rightdrawerclosed'] = 'The current preference for the navigation drawer is closed.';
$string['privacy:rightdraweropen'] = 'The current preference for the navigation drawer is open.';
$string['privacy:darkmodeoff'] = 'The current preference for the dark mode is off.';
$string['privacy:darkmodeon'] = 'The current preference for the dark mode is on.';
$string['privacy:metadata:preference:draweropennav'] = 'The user\'s preference for hiding or showing the drawer menu navigation.';
$string['privacy:drawernavclosed'] = 'The current preference for the navigation drawer is closed.';
$string['privacy:drawernavopen'] = 'The current preference for the navigation drawer is open.';

$string['totop'] = 'Go to top';

$string['region-fpblocks-t'] = 'Frontpage Blocks Area #1 (Top)';
$string['region-fpblocks-b'] = 'Frontpage Blocks Area #2 (Bottom)';
$string['region-side-pre'] = 'Hidden Sidebar';
$string['region-dtopblocks'] = 'Dashboard Top Blocks';
$string['region-dbottomblocks'] = 'Dashboard Bottom Blocks';
$string['region-ctopbl'] = 'Course - Top Blocks';
$string['region-cbottombl'] = 'Course - Bottom Blocks';
$string['region-cstopbl'] = 'Course Sections - Top Blocks';
$string['region-csbottombl'] = 'Course Sections - Bottom Blocks';
$string['region-sidebartopblocks'] = 'Sidebar - Top Blocks';
$string['region-sidebarbottomblocks'] = 'Sidebar - Bottom Blocks';
$string['region-coursetab-a'] = 'Course Tab #1';
$string['region-coursetab-b'] = 'Course Tab #2';
$string['region-coursetab-c'] = 'Course Tab #3';
$string['region-coursetab-d'] = 'Course Tab #4';
$string['region-coursetab-e'] = 'Course Tab #5';

$string['darkmodetheme'] = 'Dark Mode Switcher';
$string['darkmodetheme_desc'] = '';
$string['topbareditmode'] = 'Edit mode button on the top bar';
$string['topbareditmode_desc'] = 'Similar to the default Moodle theme.<br />
<img src="{$a->siteurl}/theme/universe/doc/topbar-universe.png" class="my-3 rounded" height="70" alt="universe Moodle Theme" />';
$string['darkmodefirst'] = 'Only Dark Mode UI';
$string['darkmodefirst_desc'] = 'Force Dark Interface Only. When enabled the Dark Mode Switcher will not be displayed.';
$string['sdarkmode'] = 'Dark Mode (Button Title/Tooltip)';
$string['sdarkmode_desc'] = '<span class="badge-sq badge-info mb-2">FAQ</span> <ul><li><span>Displaying text in multiple languages </span><a class="underline--anim" href="https://docs.moodle.org/400/en/Multi-language_content_filter" target="_blank">Learn more</a></li></ul>';
$string['slightmode'] = 'Light Mode (Button Title/Tooltip)';
$string['slightmode_desc'] = '<span class="badge-sq badge-info mb-2">FAQ</span> <ul><li><span>Displaying text in multiple languages </span><a class="underline--anim" href="https://docs.moodle.org/400/en/Multi-language_content_filter" target="_blank">Learn more</a></li></ul>';
$string['topbarscss'] = 'Logo and navigation size';
$string['topbarscss_desc'] = 'To customize size of the logo please use this code below (Go to Advanced Tab - Raw SCSS and Save):<br /><br />
<h4>Logo (Text)</h4>
<pre><code>.rui-topbar .site-name { font-size: 14px; }</code></pre>
<h4>Navigation</h4>
<pre><code>.rui-topbar ..primary-navigation .navigation .nav-link { font-size: 14px; }</code></pre>';

$string['themeauthor'] = 'Theme Author';
$string['themeauthor_desc'] = 'Show information about the author of the theme - in the source code.';

$string['fontawesome'] = 'FontAwesome (v6.5)';
$string['fontawesome_desc'] = 'Self-hosted - Web Fonts.';

$string['showcolorcoursecardmask'] = 'Display Course Card Image Mask';
$string['colorcoursecardmask'] = 'Course Card Image Mask Color';

$string['courselistview'] = 'Simple list (Course List)';
$string['courselistview_desc'] = 'Display a simple list instead default course cards. Only on the /course/index.php';

$string['thiscourse'] = 'Course Sections';
$string['nothiscourse'] = 'We cannot identify any course sections or topics';

$string['showhintcoursehiddensetting'] = 'Show hints in hidden courses';
$string['showhintcoursehiddensetting_desc'] = 'With this setting a hint will appear in the course header as long as the visibility of the course is hidden. This helps to identify the visibility state of a course at a glance without the need for looking at the course settings.';
$string['showhintcoursehiddensettingslink'] = 'You can change the visibility in the <a class="underline--anim" href="{$a->url}">course settings</a>.';
$string['showhintcoursehiddengeneral'] = 'This course is currently <strong>hidden</strong>. Only enrolled teachers can access this course when hidden.';
$string['showhintcourseguestaccesslink'] = 'To have full access to the course, you can <a class="underline--anim" href="{$a->url}">self enrol into this course</a>.';


// Edit Button Text.
$string['editon'] = 'Turn Edit On';
$string['editoff'] = 'Turn Edit Off';
$string['left'] = 'Left';
$string['center'] = 'Center';
$string['right'] = 'Right';


// Custom Alert.
$string['alertsettings'] = 'Custom Alert';
$string['displaycustomalert'] = 'Display Custom Alert';
$string['displaycustomalert_desc'] = '';
$string['closecustomalert'] = 'Close Custom Alert Permanently';
$string['closecustomalert_desc'] = '<p class="small">Remember to clear the browsing data to see the alert again.</p>';
$string['customalerthtml'] = 'Custom Alert Content';
$string['customalerthtml_desc'] = '';

// SEO.
$string['seosettings'] = 'SEO';
$string['seometadesc'] = 'Meta Description';
$string['seometadesc_desc'] = '';
$string['seoappletouchicon'] = 'Apple Touch Icon';
$string['seoappletouchicon_desc'] = '';
$string['seothemecolor'] = 'SEO Theme Color';
$string['seothemecolor_desc'] = 'The theme-color value for the name attribute of the <meta> element indicates a suggested color that user agents should use to customize the display of the page or of the surrounding user interface.
<a class="underline--anim" href="https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta/name/theme-color" target="_blank">Learn more about theme-color tag</a>';
$string['seomanifestjson'] = 'Manifest JSON';
$string['seomanifestjson_desc'] = '';

// Course Card.
$string['cccteachers'] = 'Display teachers section';
$string['cccteachers_desc'] = 'Display teachers section <strong>on the main course page.</strong>';

$string['cccteacherslist'] = 'Display teachers list section';
$string['cccteacherslist_desc'] = 'Auto-generated teachers list in tab #5';

$string['cccsummary'] = 'Display Course Summary';
$string['cccsummary_desc'] = '';

$string['coursecarddesclimit'] = 'Course Card Description - Text Limit';
$string['coursecarddesclimit_desc'] = '<span class="badge-sm badge-secondary"><strong class="mr-1">Example (text length - letters):</strong> 120</span>';

$string['cccdesc'] = 'Display course description';
$string['cccdesc_desc'] = 'Display course description on the course card.';

$string['cccteacheravatar'] = 'Display teachers (Course Card)';
$string['cccteacheravatar_desc'] = '';

$string['cccfooter'] = 'Display "Get access" buttons';
$string['cccfooter_desc'] = '';

$string['stringaccess'] = 'Get access';
$string['stringaccess_desc'] = '';

$string['cccdfooter'] = 'Show Course Card Footer <small>(Get access)</small>';
$string['cccdfooter_desc'] = '';

$string['coursecarddesclimit'] = 'Course Card Description - Text Limit';
$string['coursecarddesclimit_desc'] = '<span class="badge-sm badge-secondary"><strong class="mr-1">Example (text length - letters):</strong> 120</span>';

$string['maxcoursecardtextheight'] = 'Course Card Description - Max Height';
$string['maxcoursecardtextheight_desc'] = '<span class="badge-sm badge-secondary"><strong class="mr-1">Default:</strong> 127px</span>';


// Course Index Page.
$string['ipcoursesummary'] = 'Display course summary (Course Index Page)';
$string['ipcoursesummary_desc'] = '';
$string['ipcourseimage'] = 'Display Course Image (Course Index Page)';
$string['ipcourseimage_desc'] = '';
$string['courseimagefw'] = 'Course Image (Full Width)';
$string['courseimagefw_desc'] = '';
$string['ipcoursedetails'] = 'Display course details (Course Index Page)';
$string['ipcoursedetails_desc'] = 'Course start date, Modification date and Course end date';

$string['coursetablayout'] = 'Course Tab Layout';
$string['coursetablayout_desc'] = '<span class="badge-sq badge-info mb-2">FAQ</span> <ul><li><span>Displaying text in multiple languages </span>
<a class="underline--anim" href="https://docs.moodle.org/400/en/Multi-language_content_filter" target="_blank">Learn more</a></li></ul>';

// $string['coursedescwidth'] = 'Custom width of the Course Description Wrapper (First Tab)';
// $string['coursedescwidth_desc'] = 'If empty then the container will be full width.';

// $string['incoursedescwidth'] = 'Custom width of the Course Description Wrapper (Course subpages)';
// $string['incoursedescwidth_desc'] = 'If empty then the container will be full width.';

$string['courselangbadge'] = 'Course Language Badge';
$string['courselangbadge_desc'] = '<p>(Course - Settings - Appearance - Force Language)</p><img src="{$a->siteurl}/theme/universe/doc/course-lang-badge.jpg" class="img-fluid mt-2 rounded" width="100%" alt="Course Simple List" />';

$string['titlecoursetab1'] = 'Course Tab #1';
$string['titlecoursetab1_desc'] = '';
$string['titlecoursetab2'] = 'Course Tab #2';
$string['titlecoursetab2_desc'] = '';
$string['titlecoursetab3'] = 'Course Tab #3';
$string['titlecoursetab3_desc'] = '';
$string['titlecoursetab4'] = 'Course Tab #4';
$string['titlecoursetab4_desc'] = '';
$string['titlecoursetab5'] = 'Course Tab #5';
$string['titlecoursetab5_desc'] = '';

$string['coursetab1content'] = 'Course Tab #1 (Repeatable Content)';
$string['coursetab2content'] = 'Course Tab #2 (Repeatable Content)';
$string['coursetab3content'] = 'Course Tab #3 (Repeatable Content)';
$string['coursetab4content'] = 'Course Tab #4 (Repeatable Content)';


// Headings.
$string['hlogin'] = 'Login Page';
$string['hlogin_desc'] = 'Login page customization. You can select three layouts, add background and more.';
$string['hsignup'] = 'Sign up Page';
$string['hsignup_desc'] = 'Customization of the sign up page.';
$string['hcoursecard'] = 'Course Card';
$string['hcoursecard_desc'] = 'Customize course card e.g Get access label.';
$string['loginidprovtop'] = 'Display list of identity providers before the login form';
$string['loginidprovtop_desc'] = '';
$string['hcoursemainpage'] = 'Course Main Page';
$string['hcoursemainpage_desc'] = 'Customize course page.';
$string['hcoursepagetabs'] = 'Course Tabs';
$string['hcoursepagetabs_desc'] = 'Customize course tabs layout.';
$string['hactivityicons'] = 'Activity Icons';
$string['hactivityicons_desc'] = 'Customize activity icon colors.';

$string['hlogoarea'] = 'Logo';
$string['hlogoarea_desc'] = '';

$string['hlogoareageneral'] = 'General';
$string['hlogoareageneral_desc'] = '';

$string['hadditionalbtn'] = 'Additional Button';
$string['hadditionalbtn_desc'] = '';

// Settings -- Advanced.
$string['advancedsettings'] = 'Advanced settings';
$string['googleanalytics'] = 'Google Analytics V4 Code';
$string['googleanalyticsdesc'] = 'Please enter your Google Analytics V4 code to enable analytics on your website. The code format should be like [G-XXXXXXXXXX]';
$string['favicon'] = 'Custom favicon';
$string['favicon_desc'] = 'Upload your own favicon. It should be an <strong>.ico</strong> file. <a class="underline--anim" href="https://www.favicon-generator.org/" target="_blank">Favicon generator</a>';
$string['fontfilessetting'] = 'Font files';
$string['fontfilessetting_desc'] = 'With this dialogue you can upload own font files. The uplaod is resricted to the font files of type .eot, .woff, .woff2, .ttf and .svg. <br/>
<strong>Important:</strong> To be able to use the uploaded fonts within this theme, you have to add related code to your "Raw SCSS" area in the tab "Advanced Tab". <a class="underline--anim" href="https://rosea.gitbook.io/universe/theme-settings/google-custom-fonts-and-gdpr" target="_blank">Learn more</a>';
$string['favicon16'] = 'Custom favicon (16x16)';
$string['favicon32'] = 'Custom favicon (32x32)';
$string['favicon32'] = 'Custom favicon (32x32)';
$string['faviconsafaritab'] = 'Safari Pinned Tab (svg)';
$string['faviconsafaritabcolor'] = 'Safari Pinned Tab (color)';

// Settings -- Login page.
$string['settingslogin'] = 'Login Page';
$string['setloginlayout'] = 'Login Page Image Position';
$string['setloginlayout_desc'] = '';
$string['loginlayout1'] = '#1 - Box - Background image (middle)';
$string['loginlayout2'] = '#2 - Box - Image on the right (middle)';
$string['loginlayout3'] = '#3 - Box - Image on the left (middle)';
$string['loginlayout4'] = '#4 - Full height (left)';
$string['loginlayout5'] = '#5 - Full height (right)';
$string['loginhtmlcontent1'] = 'HTML Content #1';
$string['loginhtmlcontent1_desc'] = 'Custom HTML content<br />
<ul>
<li>for layout #1: before the logo</li>
<li>for layout #2, #3: before the login box</li>
</ul>';
$string['loginhtmlcontent2'] = 'HTML Content #2';
$string['loginhtmlcontent2_desc'] = 'Custom HTML content<br />
<ul>
<li>for layout #1: after HTML content #2</li>
<li>for layout #2, #3: next to the login form</li>
</ul>';
$string['loginhtmlcontent3'] = 'HTML Content #3';
$string['loginhtmlcontent3_desc'] = 'Custom HTML content<br />
<ul>
<li>for layout #1: after the login form</li>
<li>for layout #2, #3: under the login box</li>
</ul>';
$string['logincustomfooterhtml'] = 'Custom Footer HTML or JS';
$string['logincustomfooterhtml_desc'] = '';
$string['loginhtmlblockbottom'] = 'Custom HTML Block (under the login form)';
$string['loginhtmlblockbottom_desc'] = '';
$string['loginfootercontent'] = 'Footer Content';
$string['loginfootercontent_desc'] = 'Custom HTML content<br />
<ul>
<li>for layout #1: after the login form and HTML Content #2</li>
<li>for layout #2, #3: under the login box</li>
</ul>';
$string['loginbg'] = 'Login Page Background';
$string['loginbg_desc'] = '';
$string['loginbgcolor'] = 'Login Background Color (Image Container)';
$string['loginbgcolor_desc'] = '';
$string['customloginlogo'] = 'Custom Logo on the Login Page';
$string['customloginlogo_desc'] = '<strong>Recommendation:</strong> SVG files or png files with transparent background.';
$string['loginintrotext'] = 'Log in - Introduction';
$string['loginintrotext_desc'] = 'Code snippet:
<pre class="rui-pre">&lt;div class="alert alert--sm alert-light"&gt;Hi there!&lt;br&gt;
Use demo account to check how this theme works.
&lt;br&gt;Login: &lt;strong&gt;student&lt;/strong&gt;, password: &lt;strong&gt;Demo123#&lt;/strong&gt;
&lt;/div&gt;
&lt;hr class="hr-small"&gt;</pre>';
$string['stringca'] = 'Label next to "Create an account" button.';
$string['stringca_desc'] = 'Label displays on the Sign in page';
$string['stringbacktologin'] = 'Label next to "Log in"';
$string['stringbacktologin_desc'] = 'Label displays on the Sign up page';
$string['signuptext'] = 'Sign up Content';
$string['signuptext_desc'] = '';
$string['signupintrotext'] = 'Sign up - Introduction';
$string['signupintrotext_desc'] = '';
$string['loginlogooutside'] = 'Logo outside the container';
$string['loginlogooutside_desc'] = '';
$string['customsignupoutside'] = 'Sign up link outside the container';
$string['customsignupoutside_desc'] = 'Display the sign-up link on the right top corner. If disabled, the sign-up button will be displayed under the log-in button.';
$string['hideforgotpassword'] = 'Hide remember password link';
$string['hideforgotpassword_desc'] = '';
$string['logininfobox'] = 'Additional content under the password input field.';
$string['logininfobox_desc'] = 'Code snippet:<pre class="rui-pre"><code>&#x3C;div class=&#x22;mt-3&#x22;&#x3E;&#x3C;p class=&#x22;small&#x22;&#x3E;Sample text&#x3C;/p&#x3E;&#x3C;/div&#x3E;</code></pre>
<br /><h5>Available content fields areas.</h5>
<a href="{$a->siteurl}/theme/universe/doc/login-area-info.jpg" target="_blank" class="mt-3"><img src="{$a->siteurl}/theme/universe/doc/login-area-info.jpg" class="img-fluid rounded" alt="Login area" width="200" /></a>';

// Repeatable.
$string['none'] = 'None';
$string['haccordionend'] = '';
$string['haccordionend_desc'] = '';
$string['blockintrosubtitle'] = 'Subheading';
$string['blockintrosubtitle_desc'] = '';
$string['blockintrotitle'] = 'Heading';
$string['blockintrotitle_desc'] = '';
$string['blockintrocontent'] = 'Intro Content';
$string['blockintrocontent_desc'] = '';
$string['blockhtmlcontent'] = 'HTML Content';
$string['blockhtmlcontent_desc'] = '<a href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks" target="_blank" class="btn btn-sm btn-info">HTML Code Snippets Library</a>';
$string['blockfootercontent'] = 'Footer Content';
$string['blockfootercontent_desc'] = '';
$string['turnon'] = 'Turn on';
$string['turnon_desc'] = '';
$string['blockfw'] = 'Full-width container';
$string['blockfw_desc'] = '';


// Settings -- Course page.
$string['settingscourses'] = 'Course Page';
$string['courseprogressbar'] = 'Display Course Progress Bar';
$string['courseprogressbar_desc'] = 'Course progress bar displays on the course index sidebar<br /><div class="mt-2 w-100 text-left"><img src="{$a->siteurl}/theme/universe/doc/course-progress.png" class="img-fluid rounded" alt="universe Moodle Theme" /></div>';

$string['coursecoverheight'] = 'Course Cover Image Height';
$string['coursecoverheight_desc'] = 'use px, vh, or rem';

$string['coursecoverstyle'] = 'Course Cover Style';
$string['coursecoverstyle_desc'] = '<strong>Style #1</strong> - Default<br />
<strong>Style #2</strong> - Parallax Effect<br />
<strong>Style #3</strong> - Change height on hover';

$string['istab2active'] = 'Course Tab #2 Course Content (active by default)';
$string['istab2active_desc'] = '';

// Settings -- Top Bar.
$string['settingstopbar'] = 'Top Bar';
$string['hidenodesprimarynavigationsetting'] = 'Hide nodes in the primary navigation';
$string['hidenodesprimarynavigationsetting_desc'] = 'With this setting, you can hide one or multiple nodes from the primary navigation.';

$string['navbarlogobox'] = 'Logo as an icon (40x40 rounded container with border)';
$string['navbarlogobox_desc'] = 'You have the option to customize this element by using your own CSS code. The element in question is the <code>.rui-logo-box</code><br /><img src="{$a->siteurl}/theme/universe/doc/topbar-logo-icon.png" class="my-3 rounded" height="120" alt="universe Moodle Theme" />';

$string['hmycoursesbtn'] = 'My Courses';
$string['hmycoursesbtn_desc'] = 'Customize the sidebar "My Courses" area.';
$string['stringmycourses'] = 'My Courses';
$string['stringmycourses_desc'] = '';
$string['stringdetails'] = 'Details';
$string['stringdetails_desc'] = '';
$string['stringallcourses'] = 'List of all available courses';
$string['stringallcourses_desc'] = 'Leave this field empty if you want to hide this button.';
$string['stringnocourses'] = 'You are not enrolled in any courses.';
$string['stringnocourses_desc'] = '';
$string['topbarcustomhtml'] = 'Custom HTML Area';
$string['topbarcustomhtml_desc'] = '
<img src="{$a->siteurl}/theme/universe/doc/additional-area.jpg" class="my-3 rounded" height="60" alt="universe Moodle Theme" />
<p>Sample code snippets:</p><br /><pre class="rui-pre">&lt;span class="d-inline-flex align-items-center"&gt;
&lt;span class="mr-3"&gt;
    &lt;svg width="24px" height="24px" stroke-width="1.5" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor"&gt;
        &lt;path d="M12 11.5v5M12 7.51l.01-.011M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2 2 6.477 2 12s4.477 10 10 10z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"&gt;&lt;/path&gt;
    &lt;/svg&gt;
&lt;/span&gt;
&lt;span&gt;universe 1.1 is there!&lt;br&gt;&lt;a href="#" class="underline--anim" target="_blank"&gt;Get this theme today!&lt;/a&gt;
&lt;/span&gt;
&lt;/span&gt;</pre>';

$string['topbaradditionalbtn'] = 'Additional Button *';
$string['topbaradditionalbtn_desc'] = 'The button will be displayed next to the "Log in" button, only for non-logged-in users.<br /><span class="badge-sq badge-info mb-2">How to revert the buttons?</span><span class="badge-sq badge-light mb-2">Add this custom CSS code to: Advanced - Raw SCSS</span><pre class="rui-pre">.notloggedin .rui-icon-menu { flex-direction: row-reverse; }</pre>';
$string['stopbaradditionalbtn'] = 'Button Label';
$string['stopbaradditionalbtn_desc'] = '<span class="badge-sq badge-info mb-2">FAQ</span> <ul><li><span>Displaying text in multiple languages </span><a class="underline--anim" href="https://docs.moodle.org/400/en/Multi-language_content_filter" target="_blank">Learn more</a></li></ul>';
$string['topbaradditionalbtnurl'] = 'Button URL';
$string['topbaradditionalbtnurl_desc'] = 'Button URL';
$string['topbaradditionalbtnhtml'] = 'Custom HTML';
$string['topbaradditionalbtnhtml_desc'] = 'You can use also custom HTML code';

$string['htopbarcolors'] = 'Color Customization';
$string['htopbarcolors_desc'] = '';
$string['colortopbarbg1'] = 'Topbar Gradient Color #1';
$string['colortopbarbg2'] = 'Topbar Gradient Color #2';
$string['dmcolortopbarbg1'] = 'Topbar Gradient Color #1 <span class="badge badge-xs badge-dark mx-2">Dark Mode</span>';
$string['dmcolortopbarbg2'] = 'Topbar Gradient Color #2 <span class="badge badge-xs badge-dark mx-2">Dark Mode</span>';
$string['colortopbartext'] = 'Text';
$string['colortopbarlink'] = 'Link Color';
$string['colortopbarlink_desc'] = 'Link color inside "Custom HTML Area"';
$string['colortopbarlinkhover'] = 'Link (Hover)';
$string['colortopbarbtntext'] = 'Button Text';
$string['colortopbarbtnhover'] = 'Button Background Hover';
$string['colortopbarbtnhovertext'] = 'Button Hover Text';



// Settings -- Footer.
$string['settingsfooter'] = 'Footer';
$string['footerfw'] = 'Footer Full Width';
$string['footerfw_desc'] = '';
$string['footerblock1'] = 'Footer Block #1';
$string['footerblock1_desc'] = '';
$string['footerblock1hr'] = 'Display Footer Block #1 separator (hr)';
$string['footerblock1hr_desc'] = '<span class="small">CSS class: .rui-footer-hr--1</small>';
$string['footerblock2'] = 'Footer Block #2';
$string['footerblock2_desc'] = '';
$string['footerblock2hr'] = 'Display Footer Block #2 separator (hr)';
$string['footerblock2hr_desc'] = '<span class="small">CSS class: .rui-footer-hr--2</small>';
$string['footerblock3'] = 'Footer Block #3';
$string['footerblock3_desc'] = '';
$string['footercopy'] = 'Footer Copy';
$string['footercopy_desc'] = '';
$string['hfootercolors'] = 'Footer Color Customization';
$string['hfootercolors_desc'] = '';
$string['colorfooterbg'] = 'Footer Background Color';
$string['colorfootertext'] = 'Footer Text Color';
$string['colorfooterlink'] = 'Footer Link Color';
$string['colorfooterlinkhover'] = 'Footer Link Hover Color';
$string['colorfooterborder'] = 'Footer Border Color';
$string['footerbgimg'] = 'Footer Background (Image)';
$string['footerbgimg_desc'] = '';
$string['footercustomcss'] = 'Footer Custom CSS';
$string['showfooterbuttons'] = 'Display Footer Buttons';
$string['showfooterbuttons_desc'] = 'Default Moodle buttons on the footer like: Moodle Doc, Data retention summary, etc.';
$string['hfooterblocks'] = 'Footer Custom Blocks';
$string['hfooterblocks_desc'] = '';
$string['hfootersocial'] = 'Footer Social Icons';
$string['hfootersocial_desc'] = '';
$string['showbasicinfolist'] = 'Display footer info list';
$string['showbasicinfolist_desc'] = 'Website, Mail, Mobile';
$string['showsociallist'] = 'Display footer social list';
$string['showsociallist_desc'] = 'Check this field to show up social icons list.';
$string['website'] = 'Website Title';
$string['website_desc'] = 'Main company Website Title';
$string['cwebsiteurl'] = 'Website URL';
$string['cwebsiteurl_desc'] = 'Main company Website';
$string['mobile'] = 'Mobile';
$string['mobile_desc'] = 'Enter Mobile Number';
$string['mail'] = 'E-Mail';
$string['mail_desc'] = 'Enter E-Mail ID';
$string['facebook'] = 'Facebook URL';
$string['facebook_desc'] = 'Enter the URL of your Facebook. (i.e http://www.facebook.com/moodlehq)';
$string['customsocialicon'] = 'More icons';
$string['customsocialicon_desc'] = '<br>More icons you can find here:
<ul>
<li><a class="underline--anim" href="https://fontawesome.com/icons" target="_blank">FontAwesome</a></li>
<li><a class="underline--anim" href="https://iconic.app/" target="_blank">iconic</a></li>
<li><a class="underline--anim" href="https://css.gg/" target="_blank">css.gg</a></li>
<li><a class="underline--anim" href="https://coolicons.cool/" target="_blank">coolicons</a></li>
</ul>
<br><strong>Sample code snippet (remember to switch Atto editor to HTML view): </strong> <pre class="rui-pre"><code>&#x3C;li&#x3E;
&#x3C;a href=&#x22;#URL&#x22; target=&#x22;_blank&#x22; class=&#x22;youtube&#x22;&#x3E;
    &#x3C;svg width=&#x22;30&#x22; height=&#x22;30&#x22; fill=&#x22;none&#x22; viewBox=&#x22;0 0 24 24&#x22;&#x3E;
        &#x3C;path stroke=&#x22;currentColor&#x22; stroke-linecap=&#x22;round&#x22; stroke-linejoin=&#x22;round&#x22; stroke-width=&#x22;1.5&#x22; d=&#x22;M4.75 6.75C4.75 5.64543 5.64543 4.75 6.75 4.75H17.25C18.3546 4.75 19.25 5.64543 19.25 6.75V17.25C19.25 18.3546 18.3546 19.25 17.25 19.25H6.75C5.64543 19.25 4.75 18.3546 4.75 17.25V6.75Z&#x22;&#x3E;&#x3C;/path&#x3E;
        &#x3C;path stroke=&#x22;currentColor&#x22; stroke-linecap=&#x22;round&#x22; stroke-linejoin=&#x22;round&#x22; stroke-width=&#x22;1.5&#x22; d=&#x22;M15.25 12L9.75 8.75V15.25L15.25 12Z&#x22;&#x3E;&#x3C;/path&#x3E;
    &#x3C;/svg&#x3E;
&#x3C;/a&#x3E;
&#x3C;/li&#x3E;</code></pre>';
$string['twitter'] = 'Twitter URL';
$string['twitter_desc'] = 'Enter the URL of your twitter. (i.e http://www.twitter.com/moodlehq)';
$string['linkedin'] = 'Linkedin URL';
$string['linkedin_desc'] = 'Enter the URL of your LinkedIn. (i.e http://www.linkedin.com/moodlehq)';
$string['youtube'] = 'Youtube URL';
$string['youtube_desc'] = 'Enter the URL of your Youtube. (i.e https://www.youtube.com/user/moodlehq)';
$string['instagram'] = 'Instagram URL';
$string['instagram_desc'] = 'Enter the URL of your Instagram. (i.e https://www.instagram.com/moodlehq)';


// Content Builder.
$string['scbsettings'] = 'Blocks Order';
$string['block0'] = 'Block #0<br /><span class="mt-1 small d-block text-light w-100">Main Moodle Content</span><br /><span class="badge-xs badge-light mt-2">Go to the settings - <a class="underline--anim" href="{$a->siteurl}/admin/settings.php?section=frontpagesettings" target="_blank">Edit</a></span>';
$string['block0_desc'] = '';
$string['block1'] = 'Block #1<br /><span class="mt-1 small d-block text-light w-100">Hero Slider #1</span>';
$string['block1_desc'] = '';
$string['block2'] = 'Block #2<br /><span class="mt-1 small d-block text-light w-100">Hero Video</span>';
$string['block2_desc'] = '';
$string['block3'] = 'Block #3<br /><span class="mt-1 small d-block text-light w-100">Hero Image</span>';
$string['block3_desc'] = '';
$string['block4'] = 'Block #4<br /><span class="mt-1 small d-block text-light w-100">Hero Slider #2</span>';
$string['block4_desc'] = '';
$string['block5'] = 'Block #5<br /><span class="mt-1 small d-block text-light w-100">Grid Content #1</span>';
$string['block5_desc'] = '';
$string['block6'] = 'Block #6<br /><span class="mt-1 small d-block text-light w-100">Grid Content #2</span>';
$string['block6_desc'] = '';
$string['block7'] = 'Block #7<br /><span class="mt-1 small d-block text-light w-100">Grid Content #3</span>';
$string['block7_desc'] = '';
$string['block8'] = 'Block #8<br /><span class="mt-1 small d-block text-light w-100">Grid Content #4</span>';
$string['block8_desc'] = '';
$string['block9'] = 'Block #9<br /><span class="mt-1 small d-block text-light w-100">Grid Content #5</span>';
$string['block9_desc'] = '';
$string['block10'] = 'Block #10<br /><span class="mt-1 small d-block text-light w-100">Grid Content #6</span>';
$string['block10_desc'] = '';
$string['block11'] = 'Block #11<br /><span class="mt-1 small d-block text-light w-100">Grid Content #7</span>';
$string['block11_desc'] = '';
$string['block12'] = 'Block #12<br /><span class="mt-1 small d-block text-light w-100">Content #1</span>';
$string['block12_desc'] = '';
$string['block13'] = 'Block #13<br /><span class="mt-1 small d-block text-light w-100">Content #2</span>';
$string['block13_desc'] = '';
$string['block14'] = 'Block #14<br /><span class="mt-1 small d-block text-light w-100">Testimonials</span>';
$string['block14_desc'] = '';
$string['block15'] = 'Block #15<br /><span class="mt-1 small d-block text-light w-100">Logotypes</span>';
$string['block15_desc'] = '';
$string['block16'] = 'Block #16<br /><span class="mt-1 small d-block text-light w-100">Stats #1</span>';
$string['block16_desc'] = '';
$string['block17'] = 'Block #17<br /><span class="mt-1 small d-block text-light w-100">Team</span>';
$string['block17_desc'] = '';
$string['block18'] = 'Block #18<br /><span class="mt-1 small d-block text-light w-100">FAQ</span>';
$string['block18_desc'] = '';
$string['block19'] = 'Block #19<br /><span class="mt-1 small d-block text-light w-100">Categories List #1</span>';
$string['block19_desc'] = '';
$string['block20'] = 'Block #20<br /><span class="mt-1 small d-block text-light w-100">CTA #1</span>';
$string['block20_desc'] = '';
$string['block21'] = 'Block #21<br /><span class="mt-1 small d-block text-light w-100">CTA #2</span>';
$string['block21_desc'] = '';
$string['block22'] = 'Block #22<br /><span class="mt-1 small d-block text-light w-100">CTA #3</span>';
$string['block22_desc'] = '';
$string['block23'] = 'Block #23<br /><span class="mt-1 small d-block text-light w-100">Blocks area</span>';
$string['block23_desc'] = '';

$string['displayblockhr'] = 'Show Block Separator (hr)';
$string['displayblockhr_desc'] = '';


// Block 0 - Main Moodle Content.
$string['settingsblock0'] = 'Block #0';
$string['displayblock0_desc'] = '';

// Block 1.
$string['settingsblock1'] = 'Block #1 (Hero Slider #1)';
$string['displayblock1_desc'] = '<small>Script: <a class="underline--anim" href="https://swiperjs.com/" target="_blank">Swiper</a>.
MIT Licensed, v7.0.8 released on October 4, 2021<br /><a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/hero-blocks/block-1-hero-slider">Learn how to set up this block</a></small>';
$string['hblock1slide'] = 'Slide';
$string['hblock1slide_desc'] = '';
$string['block1count'] = 'Slider count';
$string['block1count_desc'] = '';
$string['block1slideimg'] = 'Slide Image';
$string['block1slideimg_desc'] = '';
$string['block1slidesubtitle'] = 'Slide Subheading';
$string['block1slidesubtitle_desc'] = '';
$string['block1slidetitle'] = 'Slide Heading';
$string['block1slidetitle_desc'] = '';
$string['block1slidecaption'] = 'Slide Caption';
$string['block1slidecaption_desc'] = '<br />If you want to display or hide some elements for non-logged-in users use dedicated class names:<br /><ul><li>For non-logged-in users: <strong>hidefornotloggedin</strong></li><li>For logged-in users: <strong>hideforloggedin</strong></li></ul>';
$string['block1slidecss'] = 'Slide Custom CSS';
$string['block1slidecss_desc'] = '<a class="underline--anim" href="https://css-tricks.com/almanac/properties/b/background/" target="_blank">Learn more about CSS background properties</a>';
$string['showblock1sliderwrapper'] = 'Show Colorized Content Wrapper';
$string['showblock1sliderwrapper_desc'] = '';
$string['block1sliderwrapperbg'] = 'Content Wrapper Color';
$string['block1sliderwrapperbg_desc'] = '';
$string['block1wrapperalign'] = 'Content Wrapper Alignment';
$string['block1wrapperalign_desc'] = '';

// Block 2.
$string['settingsblock2'] = 'Block #2 (Hero Video)';
$string['displayblock2_desc'] = '<small>Script: <strong>vidbg.js v2.1</strong> is licensed under The MIT License.<br />
<a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/hero-blocks/block-2-video-hero">Learn how to set up this block</a></small>';
$string['showblock2wrapper'] = 'Show Colorized Content Wrapper';
$string['showblock2wrapper_desc'] = '';
$string['block2wrapperbg'] = 'Content Wrapper Color';
$string['block2wrapperbg_desc'] = '';
$string['block2wrapperalign'] = 'Content Wrapper Alignment';
$string['block2wrapperalign_desc'] = '';
$string['block2videoposter'] = 'Video Background<br />(poster)';
$string['block2videoposter_desc'] = '';
$string['block2videomp4'] = 'Video Background<br />(mp4)';
$string['block2videomp4_desc'] = '';
$string['block2videowebm'] = 'Video Background<br />(webm)';
$string['block2videowebm_desc'] = '';
$string['block2herotitle'] = 'Heading';
$string['block2herotitle_desc'] = '';
$string['block2herocaption'] = 'Caption';
$string['block2herocaption_desc'] = '<br />If you want to display or hide some elements for non-logged-in users use dedicated class names:<br /><ul><li>For non-logged-in users: <strong>hidefornotloggedin</strong></li><li>For logged-in users: <strong>hideforloggedin</strong></li></ul>';


// Block 3.
$string['settingsblock3'] = 'Block #3 (Hero Image)';
$string['displayblock3_desc'] = '<small><a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/hero-blocks/block-3-hero-image">Learn how to set up this block</a></small>';
$string['showblock3wrapper'] = 'Show Colorized Content Wrapper';
$string['showblock3wrapper_desc'] = '';
$string['block3wrapperbg'] = 'Content Wrapper Color';
$string['block3wrapperbg_desc'] = '';
$string['block3wrapperalign'] = 'Content Wrapper Alignment';
$string['block3wrapperalign_desc'] = '';
$string['block3img'] = 'Hero Image';
$string['block3img_desc'] = '';
$string['block3videowebm_desc'] = '';
$string['block3herotitle'] = 'Heading';
$string['block3herotitle_desc'] = '';
$string['block3herocaption'] = 'Caption';
$string['block3herocaption_desc'] = '<br />If you want to display or hide some elements for non-logged-in users use dedicated class names:<br /><ul><li>For non-logged-in users: <strong>hidefornotloggedin</strong></li><li>For logged-in users: <strong>hideforloggedin</strong></li></ul>';

// Block 4.
$string['settingsblock4'] = 'Block #4 (Hero Slider #2)';
$string['displayblock4_desc'] = '<small>Script: <a class="underline--anim" href="https://swiperjs.com/" target="_blank">Swiper</a>.
MIT Licensed, v7.0.8 released on October 4, 2021<br /><a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/hero-blocks/block-1-hero-slider">Tutorial</a></small>';
$string['hblock4slide'] = 'Slide';
$string['hblock4slide_desc'] = '';
$string['block4count'] = 'Slider count';
$string['block4count_desc'] = '';
$string['block4slideimg'] = 'Slide Image';
$string['block4slideimg_desc'] = '';
$string['block4slidesubtitle'] = 'Slide Subheading';
$string['block4slidesubtitle_desc'] = '';
$string['block4slidetitle'] = 'Slide Heading';
$string['block4slidetitle_desc'] = '';
$string['block4slidecaption'] = 'Slide Caption';
$string['block4slidecaption_desc'] = '<br />If you want to display or hide some elements for non-logged-in users use dedicated class names:<br /><ul><li>For non-logged-in users: <strong>hidefornotloggedin</strong></li><li>For logged-in users: <strong>hideforloggedin</strong></li></ul>';
$string['block4slidecss'] = 'Slide Custom CSS';
$string['block4slidecss_desc'] = '<a class="underline--anim" href="https://css-tricks.com/almanac/properties/b/background/" target="_blank">Learn more about CSS background properties</a>';
$string['showblock4sliderwrapper'] = 'Show Colorized Content Wrapper';
$string['showblock4sliderwrapper_desc'] = '';
$string['block4sliderwrapperbg'] = 'Content Wrapper Color';
$string['block4sliderwrapperbg_desc'] = '';
$string['block4wrapperalign'] = 'Content Wrapper Alignment';
$string['block4wrapperalign_desc'] = '';
$string['sliderinterval'] = 'Slider interval';
$string['sliderinterval_desc'] = 'Units: 1000 -> 1s. Enable slider interval must be checked.';

// Block 5.
$string['settingsblock5'] = 'Block #5 (Grid Content #1)';
$string['displayblock5_desc'] = '';

// Block 6.
$string['settingsblock6'] = 'Block #6 (Grid Content #2)';
$string['displayblock6_desc'] = '';

// Block 7.
$string['settingsblock7'] = 'Block #7 (Grid Content #3)';
$string['displayblock7_desc'] = '';

// Block 8.
$string['settingsblock8'] = 'Block #8 (Grid Content #4)';
$string['displayblock8_desc'] = '';

// Block 9.
$string['settingsblock9'] = 'Block #9 (Grid Content #5)';
$string['displayblock9_desc'] = '';

// Block 10.
$string['settingsblock10'] = 'Block #10 (Grid Content #6)';
$string['displayblock10_desc'] = '';

// Block 11.
$string['settingsblock11'] = 'Block #11 (Grid Content #7)';
$string['displayblock11_desc'] = '';

// Block 12.
$string['settingsblock12'] = 'Block #12 (Content #1)';
$string['displayblock12_desc'] = '';
$string['hblock12item'] = 'Item';
$string['hblock12item_desc'] = '';
$string['settingsblock12'] = 'Block #12 (Content)';
$string['displayblock12_desc'] = '';
$string['block12slidesperrow'] = 'Sldies per row';
$string['block12slidesperrow_desc'] = '';
$string['block12count'] = 'Number of items';
$string['block12count_desc'] = '';
$string['block12itemimg'] = 'Image';
$string['block12itemimg_desc'] = '';
$string['block12itemtitle'] = 'Title (Alt)';
$string['block12itemtitle_desc'] = '';
$string['block12itemurl'] = 'URL with (https:// or http://)';
$string['block12itemurl_desc'] = '';


// Block 13.
$string['settingsblock13'] = 'Block #13 (Content #2)';
$string['displayblock13_desc'] = '';

// Block 14.
$string['settingsblock14'] = 'Block #14 (Testimonials)';
$string['displayblock14_desc'] = '';

// Block 15.
$string['settingsblock15'] = 'Block #15 (Logotypes)';
$string['displayblock15_desc'] = '';

// Block 16.
$string['settingsblock16'] = 'Block #16 (Stats)';
$string['displayblock16_desc'] = '';

// Block 17.
$string['settingsblock17'] = 'Block #17 (Team)';
$string['displayblock17_desc'] = '';

// Block 18.
$string['settingsblock18'] = 'Block #18 (FAQ)';
$string['displayblock18_desc'] = '';
$string['hblock18'] = 'Custom HTML';
$string['hblock18_desc'] = 'You can use HTML to display accordion items or just add it using simple form below.';
$string['hblock18_2'] = 'FAQ Items';
$string['hblock18_2_desc'] = 'Add FAQ items manually.';
$string['block18count'] = 'Number of items';
$string['block18count_desc'] = 'Number of items';
$string['block18answer'] = 'Answer';
$string['block18answer_desc'] = '';
$string['block18question'] = 'Question';
$string['block18question_desc'] = '';

// Block 19.
$string['settingsblock19'] = 'Block #19 (Categories List)';
$string['displayblock19_desc'] = '';

// Block 20.
$string['settingsblock20'] = 'Block #20 (CTA #1)';
$string['displayblock20_desc'] = '';

// Block 21.
$string['settingsblock21'] = 'Block #21 (CTA #2)';
$string['displayblock21_desc'] = '';

// Block 22.
$string['settingsblock22'] = 'Block #22 (CTA #3)';
$string['displayblock22_desc'] = '';

$string['blockbg'] = 'Background Image';
$string['blockbg_desc'] = '';
$string['blockcustomcss'] = 'Custom CSS';
$string['blockcustomcss_desc'] = '<p class="mb-3">Tutorial:
<a class="underline--anim" href="https://css-tricks.com/almanac/properties/b/background/" target="_blank">css-tricks - background properties</a>.</p>
<p class="mt-3">Sample code:</p>
<pre>background-position: bottom center; background-size: 100%; background-color: #000; background-repeat: no-repeat;</pre>
<p class="mt-3">Background Gradient Generator - <a class="underline--anim" href="https://mycolor.space/gradient" target="_blank">mycolor.space/gradient</a></p>';
$string['blocktextalign'] = 'Text alignment';
$string['blocktextalign_desc'] = '';
$string['blocktitle'] = 'Heading';
$string['blocktitle_desc'] = '';
$string['blocktitlesize'] = 'Heading Size';
$string['blocktitlesize_desc'] = 'Normal: 40px , Large: 60px , Extra large: 80px';
$string['blocktitleweight'] = 'Heading Font Weight';
$string['blocktitleweight_desc'] = '';
$string['blocktitlecolor'] = 'Heading Color';
$string['blocktitlecolor_desc'] = '';

// Block 23.
$string['settingsblock23'] = 'Block #23 (Blocks Area)';
$string['displayblock23_desc'] = '';

// Customization.
$string['settingscustomization'] = 'Customization';
$string['hfontsettings'] = 'Fonts Settings';
$string['hfontsettings_desc'] = 'Customize Font Properties';
$string['hgooglefont'] = 'Google Font';
$string['hgooglefont_desc'] = 'Google Fonts is a library of 1,284 free licensed font families.
<a class="underline--anim" href="https://fonts.google.com" target="_blank">Google Fonts Library</a>.';
$string['googlefonturl'] = 'Google Font URL';
$string['googlefonturl_desc'] = "Leave empty if you don't want to use Google Font.";
$string['fontbody'] = 'Font Name (Body)';
$string['fontbody_desc'] = "";
$string['fontheadings'] = 'Font Name (Headings)';
$string['fontheadings_desc'] = "Leave empty if you don't use additional font for headings.";
$string['fontweightregular'] = 'Font weight: Regular';
$string['fontweightregular_desc'] = 'e.g 400';
$string['fontweightmedium'] = 'Font weight: Medium';
$string['fontweightmedium_desc'] = 'e.g 500, 600';
$string['fontweightbold'] = 'Font weight: Bold';
$string['fontweightbold_desc'] = 'e.g 700, 800, 900<br />';
$string['fontweightheadings'] = 'Font weight (Headings)';
$string['fontweightheadings_desc'] = 'e.g 700, 800, 900';

$string['hgeneral'] = 'General';
$string['hgeneral_desc'] = '';
$string['colorbodybg'] = 'Body Background Color';
$string['colorborder'] = 'Border Color (Global)';
$string['btnborderradius'] = 'Button Border Radius (px)';

$string['topbarlogoareaon'] = 'Turn on a logo area';
$string['topbarlogoareaon_desc'] = 'Select to turn on a logo area on the top bar. You can upload an image, use
<a class="underline--anim" href="#admin-customlogotxt">custom text</a>
or <a class="underline--anim" href="{$a->siteurl}/admin/settings.php?section=frontpagesettings" target="_blank">default moodle site name (shortname).</a>';
$string['customlogo'] = 'Logo (Top Bar)';
$string['customlogo_desc'] = '';
$string['customdmlogo'] = 'Dark mode - Logo (Top Bar)';
$string['customdmlogo_desc'] = '';
$string['customlogotxt'] = 'Logo (Text)';
$string['customlogotxt_desc'] = '';
$string['customlogoandname'] = 'Display Text Next to The Logo';
$string['customlogoandname_desc'] = 'Don\'t forgot to add Company/Site Name';

$string['hcolorstxt'] = 'Text Colors <span class="badge badge-sm badge-light mx-2">Not recommended to change</span>';
$string['hcolorstxt_desc'] = '<p>Compatible with WCAG Principles.</p><p>Change only when you really need to.</p>';
$string['colorheadings'] = 'Headings';
$string['colorbody'] = 'Text Color';
$string['colorbodysecondary'] = 'Text Color (Secondary)';
$string['colorbodylight'] = 'Text Color (Light)';
$string['colorlink'] = 'Link Color';
$string['colorlinkhover'] = 'Link Color (Hover)';

$string['hcolorsgrays'] = 'Grays <span class="badge badge-sm badge-light mx-2">Not recommended to change</span>';
$string['hcolorsgrays_desc'] = '<p>I used gray shades compatible with WCAG Principles.</p>
<p>Change only when you really need to.</p><br /><div class="d-inline-flex flex-wrap"><div class="sqcolor bg-gray-100 bg--desc m-1"></div>
<div class="sqcolor bg-gray-200 bg--desc m-1"></div><div class="sqcolor bg-gray-300 bg--desc m-1"></div><div class="sqcolor bg-gray-400 bg--desc m-1"></div>
<div class="sqcolor bg-gray-500 bg--desc m-1"></div><div class="sqcolor bg-gray-600 bg--desc m-1"></div><div class="sqcolor bg-gray-700 bg--desc m-1"></div>
<div class="sqcolor bg-gray-800 bg--desc m-1"></div><div class="sqcolor bg-gray-900 bg--desc m-1"></div></div>';
$string['colorgray100'] = 'Gray 100';
$string['colorgray200'] = 'Gray 200';
$string['colorgray300'] = 'Gray 300<br /><small class="mx-2">e.g main borders color</small>';
$string['colorgray400'] = 'Gray 400';
$string['colorgray500'] = 'Gray 500';
$string['colorgray600'] = 'Gray 600';
$string['colorgray700'] = 'Gray 700';
$string['colorgray800'] = 'Gray 800';
$string['colorgray900'] = 'Gray 900';
$string['colorgray_desc'] = '';

$string['hcolorsprimary'] = 'Primary colors';
$string['hcolorsprimary_desc'] = 'Primary buttons, top bar, all important/primary UI elements.<br />
<div class="d-inline-flex flex-wrap"><div class="sqcolor bg-primary-100 bg--desc m-1"></div>
<div class="sqcolor bg-primary-200 bg--desc m-1"></div><div class="sqcolor bg-primary-300 bg--desc m-1"></div>
<div class="sqcolor bg-primary-400 bg--desc m-1"></div><div class="sqcolor bg-primary-500 bg--desc m-1"></div>
<div class="sqcolor bg-primary-600 bg--desc m-1"></div><div class="sqcolor bg-primary-700 bg--desc m-1"></div>
<div class="sqcolor bg-primary-800 bg--desc m-1"></div><div class="sqcolor bg-primary-900 bg--desc m-1"></div>
</div>';
$string['colorprimary100'] = 'Primary 100';
$string['colorprimary200'] = 'Primary 200';
$string['colorprimary300'] = 'Primary 300';
$string['colorprimary400'] = 'Primary 400';
$string['colorprimary500'] = 'Primary 500';
$string['colorprimary600'] = 'Primary 600 - Main Theme Color';
$string['colorprimary700'] = 'Primary 700';
$string['colorprimary800'] = 'Primary 800';
$string['colorprimary900'] = 'Primary 900';
$string['colorprimary_desc'] = '<span class="badge badge-sq badge-warning">To generate automatically the colour palette just set up the "Main Theme Color - 600"</span>
<p class="mt-2">
<small>If you want to change any color from the palette just add custom HEX color value to the field.</small>
</p>';
$string['color_desc'] = '';

$string['additionalid'] = 'Custom Block ID';
$string['additionalid_desc'] = '<strong class="badge badge-danger mr-2">Only for developers.</strong>Custom, unique ID for the block.';
$string['additionalblock0id_desc'] = '<strong class="badge badge-danger mr-2">Only for developers.</strong>Custom, unique ID for the block.
<br /><h4>Main Moodle Content</h4>
<span>This is the section designated for the default blocks on the Moodle front page, such as the course list and categories list.</span>
<div class="mt-2"><p>Front page settings - <a class="underline--anim" href="{$a->siteurl}/admin/settings.php?section=frontpagesettings" target="_blank">Edit</a></p>
<p class="mt-2">Learn more about block customization - <a href="https://rosea.gitbook.io/universe-moodle-theme/demo-content/front-page-block-0" target="_blank">Theme Documentation</a></p></div>';

$string['additionalclass'] = 'Additional Class Name';
$string['additionalclass_desc'] = '<strong class="badge badge-warning mr-2">Only for developers.</strong><span>You can add multiple class names e.g class1 class2 class3 </span>
<a class="underline--anim" href="https://rosea.gitbook.io/universe/demo-content/front-page-blocks/advanced-options/custom-css-field" target="_blank">Learn more</a>';

$string['hintro'] = '<img src="{$a->siteurl}/theme/universe/doc/theme-icon.png" class="img-fluid my-3" width="80" height="80" alt="universe Moodle Theme" />
<div class="lead-3">universe for Moodle 4.3</div>';
$string['hintro_desc'] = '
<div class="mt-1 small">by <a class="underline--anim" href="https://rosea.io">RoseaThemes</a></div><hr class="mt-3" />
<div class="mt-3"><span class="badge badge-primary"><a class="underline--anim" href="https://rosea.gitbook.io/universe/changelog" target="_blank">Version: 1.3.2</a></span></div>
<div class="mt-4"><h3 class="lead-4 mb-2">Need help with theme customization?<br />Or you want to report a bug?</h3>Just let me know.
Open <a class="underline--anim" href="https://roseathemes.ticksy.com" target="_blank">a ticket</a> or contact me via support form on the ThemeForest item page.</div>
<a class="underline--anim" href="https://rosea.gitbook.io/universe-moodle-theme/" target="_blank" class="btn btn-sm btn-dark mt-3">Online documentation</a>
';

// Credits: BoostCampus.
// Setting: Show hint for switched role setting.
$string['showswitchedroleincoursesetting'] = 'Show hint for switched role';
$string['showswitchedroleincoursesetting_desc'] = 'Enabling this option shows a hint in the course header if the user switched roles in the course. It also provides a link to switch back within the course page.
<br /><img src="{$a->siteurl}/theme/universe/doc/hints.png" class="img-fluid rounded my-3" style="max-height: 200px; width: auto; max-width: 100%;" alt="Universe Theme for Moodle" />';
$string['switchedroleto'] = 'You are viewing this course currently with the role: <strong>{$a->role}</strong>';
// Setting: Show hint for hidden course.
$string['showhintcoursehiddensetting'] = 'Show hint in hidden courses';
$string['showhintcoursehiddensetting_desc'] = 'With this setting a hint will appear in the course header as long as the visibility of the course is hidden. This helps to identify the visibility state of a course at a glance without the need for looking at the course settings.';
$string['showhintcoursehiddengeneral'] = 'This course is currently <strong>hidden</strong>. Only enrolled teachers can access this course when hidden.';
$string['showhintcoursehiddensettingslink'] = 'You can change the visibility in the <a href="{$a->url}">course settings</a>.';
// Setting: Show hint for guest access.
$string['showhintcoursguestaccesssetting'] = 'Show hint for guest access';
$string['showhintcourseguestaccesssetting_desc'] = 'With this setting a hint will appear in the course header when a user is accessing it with the guest access feature. If the course provides an active self enrolment, a link to that page is also presented to the user.';
$string['showhintcourseguestaccessgeneral'] = 'You are currently viewing this course as <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccessgeneralinfo'] = 'Please log in to check how to enrol into the course and get full access.';
$string['showhintcourseguestaccesslink'] = 'To have full access to the course, you can <a href="{$a->url}">self enrol into this course</a>.';
// Setting: Show hint for unrestricted self enrolment.
$string['showhintcourseselfenrolsetting'] = 'Show hint for self enrolment without enrolment key';
$string['showhintcourseselfenrolsetting_desc'] = 'With this setting a hint will appear in the course header if the course is visible and an enrolment without enrolment key is currently possible.';
$string['showhintcourseselfenrolstartcurrently'] = 'This course is currently visible to everyone and <strong>self enrolment without an enrolment key</strong> is possible.';
$string['showhintcourseselfenrolstartfuture'] = 'This course is currently visible to everyone and <strong>self enrolment without an enrolment key</strong> is planned to become possible.';
$string['showhintcourseselfenrolunlimited'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment indefinitely.';
$string['showhintcourseselfenroluntil'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment until {$a->until}.';
$string['showhintcourseselfenrolfrom'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment from {$a->from} on.';
$string['showhintcourseselfenrolsince'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment currently.';
$string['showhintcourseselfenrolfromuntil'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment from {$a->from} until {$a->until}.';
$string['showhintcourseselfenrolsinceuntil'] = 'The <strong>{$a->name}</strong> enrolment instance allows unrestricted self enrolment until {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'If you don\'t want any Moodle user to have access to this course freely, please restrict the self enrolment settings.';

// Moodle 4..
$string['showfooter'] = 'Show footer';
$string['privacy:metadata:preference:draweropenblock'] = 'The user\'s preference for hiding or showing the drawer with blocks.';
$string['privacy:metadata:preference:draweropenindex'] = 'The user\'s preference for hiding or showing the drawer with course index.';
$string['privacy:metadata:preference:draweropennav'] = 'The user\'s preference for hiding or showing the drawer menu navigation.';
$string['privacy:drawerindexclosed'] = 'The current preference for the index drawer is closed.';
$string['privacy:drawerindexopen'] = 'The current preference for the index drawer is open.';
$string['privacy:drawerblockclosed'] = 'The current preference for the block drawer is closed.';
$string['privacy:drawerblockopen'] = 'The current preference for the block drawer is open.';
$string['privacy:drawernavclosed'] = 'The current preference for the navigation drawer is closed.';
$string['privacy:drawernavopen'] = 'The current preference for the navigation drawer is open.';
$string['unaddableblocks'] = 'Unneeded blocks';
$string['unaddableblocks_desc'] = 'The blocks specified are not needed when using this theme and will not be listed in the \'Add a block\' menu.';

// universe (1.2.1).
$string['hcoursenavitems'] = 'Course Navigation Items';
$string['hcoursenavitems_desc'] = 'Turn on/off any navigation items like: Participants, Grades, Competencies, Badges.';
$string['isitemongrades'] = 'Grade';
$string['isitemongrades_desc'] = '';
$string['isitemonparticipants'] = 'Participants';
$string['isitemonparticipants_desc'] = '';
$string['isitemonbadges'] = 'Badges';
$string['isitemonbadges_desc'] = '';
$string['isitemoncompetencies'] = 'Competencies';
$string['isitemoncompetencies_desc'] = '';

$string['hmainnav'] = 'Main Navigation Items';
$string['hmainnav_desc'] = 'Customization of the Main Navigation Items';
$string['isitemonsitehome'] = 'Site home';
$string['isitemonsitehome_desc'] = '';
$string['isitemondashboard'] = 'Dashboard';
$string['isitemondashboard_desc'] = '';
$string['isitemoncalendar'] = 'Calendar';
$string['isitemoncalendar_desc'] = '';
$string['isitemonprivatefiles'] = 'Private files';
$string['isitemonprivatefiles_desc'] = '';
$string['isitemoncontentbank'] = 'Content bank';
$string['isitemoncontentbank_desc'] = '';
$string['isitemonmycourses'] = 'My courses';
$string['isitemonmycourses_desc'] = '';

$string['hvpcss'] = 'H5P CSS';
$string['hvpcss_desc'] = 'Custom CSS code to be applied to H5P activities';

$string['hidecourseindexnav'] = 'Hide Course Index Navigation';
$string['hidecourseindexnav_desc'] = 'Hide or show the Course Index drawer navigation.';

// Activity Icons.
$string['hactivityicons'] = 'Activity Icons';
$string['hactivityicons_desc'] = 'Customize activity icon colors.<br />To change the icon color from black to white just add a custom CSS (Advanced - Raw SCSS). <pre>.activityiconcontainer .activityicon, .activityiconcontainer .icon { filter: invert(1); }</pre>';

$string['iconadministration'] = 'Activity Icon (administration)';
$string['iconassessment'] = 'Activity Icon (assessment)';
$string['iconcolleboration'] = 'Activity Icon (colleboration)';
$string['iconcommunication'] = 'Activity Icon (communication)';
$string['iconcontent'] = 'Activity Icon (content)';
$string['iconinterface'] = 'Activity Icon (interface)';

$string['backtotop'] = 'Back to top button';
$string['backtotop_desc'] = '';

$string['showcustomfields'] = 'Show custom fields';
$string['showcustomfields_desc'] = '';

$string['secnavgroupitem'] = 'Include Groups Item to the Secondary Navigation';
$string['secnavgroupitem_desc'] = 'For users who have capabilities such as moodle/course:managegroups. <br /><img src="{$a->siteurl}/theme/universe/doc/secondary-nav-course-tmpl.png" width="w-100 rounded" style="max-height:150px;" />';

$string['settingscoursesnav'] = 'Course Page - Secondary Navigation';

$string['secnavitems'] = 'Turn on additional menu items';
$string['secnavitems_desc'] = 'Select and save to turn on additional options for customizing secondary navigation.';

$string['hsecnavitem'] = 'Item';
$string['hsecnavitem_desc'] = '';

$string['secnavitemscount'] = 'Number of custom items';
$string['secnavitemscount_desc'] = '';

$string['secnavcustomnavlabel'] = 'Label';
$string['secnavcustomnavlabel_desc'] = '';

$string['secnavcustomnavurl'] = 'URL';
$string['secnavcustomnavurl_desc'] = 'To add course ID to the URL, just use {{courseID}}. eg. https://localhost/group/index.php?id={{courseID}}';

$string['secnavuserrole1'] = 'Select user role';
$string['secnavuserrole1_desc'] = 'Add restrictions depends on user roles.';
$string['secnavuserrole'] = 'Select user role';
$string['secnavuserrole_desc'] = 'Add restrictions depends on user roles.';
$string['secnavuserroles'] = 'Select user role';
$string['secnavuserroles_desc'] = 'Add restrictions depends on user roles.';

$string['rolemanager'] = 'Manager';
$string['rolecoursecreator'] = 'Course Creator';
$string['roleeditingteacher'] = 'Teacher (editing)';
$string['rolenoneditingteacher'] = 'Teacher (non-editing)';
$string['roleguest'] = 'Guest';
$string['rolestudent'] = 'Student';
$string['roleauthenticateduser'] = 'Authenticated user';

// Dark mode more options.
$string['dmcolor_desc'] = '';

$string['hdmgeneral'] = 'General <span class="badge badge-xs badge-dark mx-2">Dark Mode</span>';
$string['hdmgeneral_desc'] = 'Background and border color, button radius';
$string['dmcolorbodybg'] = 'Body Background Color';
$string['dmcolorborder'] = 'Border Color (Global)';

$string['hdmcolorstxt'] = 'Text Colors <span class="badge badge-xs badge-dark mx-2">Dark Mode</span> <span class="badge badge-sm badge-light mx-2">Not recommended to change</span>';
$string['hdmcolorstxt_desc'] = '<p>Compatible with WCAG Principles.</p><p>Change only when you really need to.</p>';
$string['dmcolorheadings'] = 'Headings';
$string['dmcolorbody'] = 'Text Color';
$string['dmcolorbodysecondary'] = 'Text Color (Secondary)';
$string['dmcolorbodylight'] = 'Text Color (Light)';
$string['dmcolorlink'] = 'Link Color';
$string['dmcolorlinkhover'] = 'Link Color (Hover)';

$string['hdmcolorsgrays'] = 'Grays <span class="badge badge-xs badge-dark mx-2">Dark Mode</span> <span class="badge badge-sm badge-light mx-2">Not recommended to change</span>';
$string['hdmcolorsgrays_desc'] = '<p>I used gray shades compatible with WCAG Principles.</p>
<p>Change only when you really need to.</p><br /><div class="d-inline-flex flex-wrap">
<div class="sqcolor bg-dm-gray-100 bg--desc m-1"></div><div class="sqcolor bg-dm-gray-200 bg--desc m-1"></div>
<div class="sqcolor bg-dm-gray-300 bg--desc m-1"></div><div class="sqcolor bg-dm-gray-400 bg--desc m-1"></div>
<div class="sqcolor bg-dm-gray-500 bg--desc m-1"></div><div class="sqcolor bg-dm-gray-600 bg--desc m-1"></div>
<div class="sqcolor bg-dm-gray-700 bg--desc m-1"></div><div class="sqcolor bg-dm-gray-800 bg--desc m-1"></div>
<div class="sqcolor bg-dm-gray-900 bg--desc m-1"></div></div>';
$string['dmcolorgray100'] = 'Gray 100';
$string['dmcolorgray200'] = 'Gray 200';
$string['dmcolorgray300'] = 'Gray 300<br /><small class="mx-2">e.g main borders color</small>';
$string['dmcolorgray400'] = 'Gray 400';
$string['dmcolorgray500'] = 'Gray 500';
$string['dmcolorgray600'] = 'Gray 600';
$string['dmcolorgray700'] = 'Gray 700';
$string['dmcolorgray800'] = 'Gray 800';
$string['dmcolorgray900'] = 'Gray 900';
$string['dmcolorgray_desc'] = '';

$string['colorgradientheading1'] = 'Heading Gradient #1';
$string['colorgradientheading2'] = 'Heading Gradient #2';
$string['dmcolorgradientheading1'] = 'Heading Gradient #1';
$string['dmcolorgradientheading2'] = 'Heading Gradient #2';

$string['forcefwvideo'] = 'Force full-width video';
$string['forcefwvideo_desc'] = 'Turn off this option to revert to the default Moodle video size settings.
<br /><img src="{$a->siteurl}/theme/universe/doc/video-size.jpg" class="img-fluid rounded my-3" style="max-height: 200px; width: auto; max-width: 100%;" alt="universe Theme for Moodle" />';

$string['settingsdashboard'] = 'Dashboard';
$string['setdashboardlayout'] = 'Dashboard Page Layout';
$string['dashboardblock1'] = 'Dashboard HTML Block #1 (On the top)';
$string['dashboardblock1_desc'] = '';
$string['dashboardblock2'] = 'Dashboard HTML Block #2 (On the bottom)';
$string['dashboardblock2_desc'] = '';

$string['settingsmycourses'] = 'My Courses';
$string['mycoursesblock1'] = 'My Courses HTML Block #1 (On the top)';
$string['mycoursesblock1_desc'] = '<img src="{$a->siteurl}/theme/universe/doc/mycourses-html-area.png" width="w-100 rounded" style="max-width:100%;" />';
$string['mycoursesblock2'] = 'My Courses HTML Block #2 (On the bottom)';
$string['mycoursesblock2_desc'] = '<img src="{$a->siteurl}/theme/universe/doc/mycourses-html-area-2.png" width="w-100 rounded" style="max-width:100%;" />';

$string['fontfilessetting'] = 'Font files';
$string['fontfilessetting_desc'] = '';
// Section: Custom fonts. Credits: Boost_Union
$string['customfontsheading'] = 'Custom fonts';
// Setting: Custom fonts.
$string['customfontssetting'] = 'Custom fonts';
$string['customfontssetting_desc'] = 'With this dialogue you can upload own font files. The uplaod is resricted to the font files of type .eot, .woff, .woff2, .ttf and .svg. <br/><br/>
<strong>Important:</strong> To be able to use the uploaded fonts within this theme, you have to add related code to your "Raw SCSS" area in the tab "Advanced Tab". <a class="underline--anim" href="https://rosea.gitbook.io/universe/theme-settings/google-custom-fonts-and-gdpr" target="_blank">Learn more</a>.<br /> The advantage of uploading fonts to this file area is that those fonts can be delivered without a check if the user is logged in and can be used as locally installed fonts everywhere on the site. As soon as you have uploaded at least one font to this filearea and have stored the settings, a list will appear underneath which will give you CSS code snippets which you can use as a boilerplate to reference particular fonts in your custom SCSS.';
// Information: Custom fonts list.
$string['customfontslistsetting'] = '<br /><br />Custom fonts list';
$string['customfontslistsetting_desc'] = '<br /><br />This is the list of fonts which you have uploaded to the custom fonts filearea. The given CSS snippets can be used to add these fonts to your custom SCSS. Please note that you will have to take care of the font format value as well as the font-family, font-style and font-weight CSS properties yourself for now as Boost Union is not able yet to parse the font files.';
$string['customfontsfileurlpersistent'] = 'URL (persistent)';
$string['customfontsfileurlrevisioned'] = 'URL (revisioned)';

// Credits: Boost_Union
$string['resourcestab'] = 'Resources';
$string['resourcescachecontrolnote'] = 'Please note that the files are shipped to the browser with the \'Cache-Control\' header set which tells the browser to cache the file. If you are sure that you won\'t change the file in the near future, you can use the persistent URL to link to the file. However, if you plan to modify a file but keep the same filename every now and then, you should rather use the revisioned URL and re-link the file where you have used it everytime you update the file to avoid that the browsers will show cached outdated versions of the file.';
// Section: Additional resources.
$string['additionalresourcesheading'] = 'Additional resources';
// Setting: Additional resources.
$string['additionalresourcessetting'] = 'Additional resources';
$string['additionalresourcessetting_desc'] = 'With this setting you can upload additional resources to the theme. The advantage of uploading files to this file area is that those files can be delivered without a check if the user is logged in. This is also why you should only add files that are uncritical and everyone should be allowed to access and don\'t need be protected with a valid login. As soon as you have uploaded at least one file to this filearea and have stored the settings, a list will appear underneath which will give you the URL which you can use to reference a particular file.';
// Information: Additional resources list.
$string['additionalresourceslistsetting'] = 'Additional resources list';
$string['additionalresourceslistsetting_desc'] = 'This is the list of files which you have uploaded to the additional resources filearea. The given URLs can be used to link to these files from within your custom CSS, from the footnote or wherever you need to use uploaded files but can\'t upload files in place.';
$string['additionalresourcesfileurlpersistent'] = 'URL (persistent)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisioned)';

$string['backtotopbutton'] = 'Go to top';

// E-mail Template Branding.
$string['email_tab_title'] = 'Email';
$string['email_general_heading'] = 'General';

$string['customemailtmpl'] = 'Email Custom Template';
$string['customemailtmpl_desc'] = '';


// Logo.
$string['email_logo_heading'] = 'Logo';
$string['email_logo_file'] = 'Upload logo for email template.';
$string['email_logo_file_desc'] = 'SVG logo is not allowed.';
$string['email_logo_height'] = 'Height of logo';
$string['email_logo_alt'] = 'Logo alt text';
$string['email_logo_href'] = 'Logo link';
$string['email_preview'] = 'Important';
$string['email_preview_desc'] = '<strong>eMail Test Plugin</strong> - <a href="https://moodle.org/plugins/local_mailtest" target="_blank">Download</a>
<br />Moodle eMailTest is a powerful tool that enables administrators to test Moodle\'s email system with ease.
<br /><br /><strong>Once you have added any options, please make sure to save your changes and clear the cache.</strong><br />(Go to: Dashboard → Site administration → Development → Purge all cache)';

// Footer.
$string['email_footer_heading'] = 'Footer';

$string['email_footer_text'] = 'Footer text';
$string['email_footer_copyright'] = 'Copyright';
$string['email_footer_displaylogo'] = 'Display logo';

// Typography.
$string['email_typo_heading'] = 'Typography';

$string['email_typo_heading'] = 'Typography';
$string['email_typo_fontfamily'] = 'Font-family';

$string['email_typo_text_fontsize'] = 'Body font size';
$string['email_typo_text_color'] = 'Body font color';

$string['email_typo_link_color'] = 'Link font color';

$string['email_typo_footer_fontsize'] = 'Footer font size';
$string['email_typo_footer_color'] = 'Footer font color';

$string['customemailsettings'] = 'Custom E-mail';

$string['rolemanager'] = 'Manager';
$string['rolecoursecreator'] = 'Course Creator';
$string['roleeditingteacher'] = 'Teacher (editing)';
$string['rolenoneditingteacher'] = 'Teacher (non-editing)';
$string['roleguest'] = 'Guest';
$string['rolestudent'] = 'Student';
$string['roleauthenticateduser'] = 'Authenticated user';

global $CFG, $PAGE, $OUTPUT;
$logo_img = '';
$theme = theme_config::load('universe');


    if(!empty(get_config('theme_universe', 'email_logo_file'))) {
        $logo_img = 'https:' . $PAGE->theme->setting_file_url('email_logo_file', 'email_logo_file');
    } else {
        $logo_img = 'https:' . $PAGE->theme->setting_file_url('customlogo', 'customlogo');
    }
    
    $footer_text = get_config('theme_universe', 'email_footer_text');
    $footer_copyright = get_config('theme_universe', 'email_footer_copyright');
    $email_logo_alt = get_config('theme_universe', 'email_logo_alt');
    $email_logo_height = get_config('theme_universe', 'email_logo_height');
    $email_logo_href = get_config('theme_universe', 'email_logo_href');
    $email_footer_displaylogo = get_config('theme_universe', 'email_footer_displaylogo');
    $email_typo_link_color = get_config('theme_universe', 'email_typo_link_color');
    $email_typo_footer_fontsize = get_config('theme_universe', 'email_typo_footer_fontsize');
    $email_typo_footer_color = get_config('theme_universe', 'email_typo_footer_color');
    $email_typo_text_fontsize = get_config('theme_universe', 'email_typo_text_fontsize');
    $email_typo_fontfamily = get_config('theme_universe', 'email_typo_fontfamily');
    $email_typo_text_color = get_config('theme_universe', 'email_typo_text_color');
    
    $string['tmpl_footer_copyright'] = $footer_copyright;
    $string['tmpl_footer_text'] = $footer_text;
    $string['tmple_typography_link_color'] = 'color:' . $email_typo_link_color. ';';
    $string['tmple_typography_link_color_h'] = $email_typo_link_color;
    $string['tmple_typography_footer_fontsize'] = 'font-size:' . $email_typo_footer_fontsize. ';';
    $string['tmple_typography_footer_color'] = 'color:' . $email_typo_footer_color. ';';
    $string['tmple_typography_text_fontsize'] = 'font-size:' . $email_typo_text_fontsize. ';';
    $string['tmple_typography_fontfamily'] = 'font-family:' . $email_typo_fontfamily. ';';
    $string['tmple_typography_text_color'] = 'color:' . $email_typo_text_color . ';';
    
    if(!empty($email_logo_href)) {
        $string['tmpl_logo_img'] = '<a href="' . $email_logo_href . '"><img src="'. $logo_img . '" height="' . $email_logo_height . '" alt="' . $email_logo_alt . '" title="' . $email_logo_alt . '" style="border:none;" /></a>';
    } else {
        $string['tmpl_logo_img'] = '<img src="'. $logo_img . '" height="' . $email_logo_height . '" alt="' . $email_logo_alt . '" title="' . $email_logo_alt . '" style="border:none;" />';
    }
    
    if($email_footer_displaylogo == 1) {
        if(!empty($email_logo_href)) {
            $string['email_footer_displaylogo_ch'] = '<a href="' . $email_logo_href . '"><img src="'. $logo_img . '" height="' . $email_logo_height . '" alt="' . $email_logo_alt . '" title="' . $email_logo_alt . '" style="border:none;" /></a>';
        } else {
            $string['email_footer_displaylogo_ch'] = '<img src="'. $logo_img . '" height="' . $email_logo_height . '" alt="' . $email_logo_alt . '" title="' . $email_logo_alt . '" style="border:none;" />';
        }
    } else {
        $string['email_footer_displaylogo_ch'] = '';
    }    
