<?php

class StaticsBlocks
{
    public $user;
    public $userID;
    public $currentUser;
    public $blockManager;
    public $blockNames;
    public $regionName;

    public function __construct($regionName, $blockNames)
    {
        global $USER, $PAGE;
        require_login(null, false);

        if (isguestuser()) {
            throw new require_login_exception('Guests are not allowed here.');
        }

        $this->userID = optional_param('userid', $USER->id, PARAM_INT);
        $this->currentUser = $this->userID == $USER->id;
        $this->user = core_user::get_user($this->userID);
        $this->blockManager = $PAGE->blocks;
        $this->blockNames = $blockNames;
        $this->regionName = $regionName;

        if (!$this->user || !core_user::is_real_user($this->userID)) {
            throw new moodle_exception('invaliduser', 'error');
        }
    }

    public function addRegion()
    {
        if (!in_array($this->regionName, $this->blockManager->get_regions())) {
            $this->blockManager->add_region($this->regionName);
        }
    }

    public function addBlocksIfNotExist()
    {
        $blocks = $this->blockManager->get_blocks_for_region($this->regionName);
        $blockNamesInBlocks = array_map(fn($block) => $block->name(), $blocks);

        foreach ($this->blockNames as $blockName) {
            if (!in_array($blockName, $blockNamesInBlocks)) {
                $this->blockManager->add_block($blockName, $this->regionName, 1, true);
            }
        }
    }

    public function renderBlocks()
    {
        global $OUTPUT;

        $this->addRegion(); // Validar si la región existe y añadirla en caso de no existir

        $this->blockManager->load_blocks(true); // Cargar bloques en la región

        $this->addBlocksIfNotExist(); // Agrega los bloques establecidos en caso de que no existan

        return $OUTPUT->blocks_for_region($this->regionName); // Devolver los bloques de la región
    }
}
